/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.encryption.s3.internal.CipherSubscriber;
import software.amazon.encryption.s3.legacy.internal.RangedGetUtils;
import software.amazon.encryption.s3.materials.CryptographicMaterials;

public class CipherPublisher
implements SdkPublisher<ByteBuffer> {
    private final SdkPublisher<ByteBuffer> wrappedPublisher;
    private final CryptographicMaterials materials;
    private final Long contentLength;
    private final long[] range;
    private final String contentRange;
    private final int cipherTagLengthBits;
    private final byte[] iv;
    private final byte[] messageId;

    public CipherPublisher(SdkPublisher<ByteBuffer> wrappedPublisher, Long contentLength, long[] range, String contentRange, int cipherTagLengthBits, CryptographicMaterials materials, byte[] iv, byte[] messageId) {
        this.wrappedPublisher = wrappedPublisher;
        this.materials = materials;
        this.contentLength = contentLength;
        this.range = range;
        this.contentRange = contentRange;
        this.cipherTagLengthBits = cipherTagLengthBits;
        this.iv = iv;
        this.messageId = messageId;
    }

    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        Subscriber<? super ByteBuffer> wrappedSubscriber = RangedGetUtils.adjustToDesiredRange(subscriber, this.range, this.contentRange, this.cipherTagLengthBits);
        this.wrappedPublisher.subscribe((Subscriber)new CipherSubscriber(wrappedSubscriber, this.contentLength, this.materials, this.iv, this.messageId));
    }
}

