/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.S3EncryptionClientSecurityException;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.internal.CryptoFactory;
import software.amazon.encryption.s3.internal.HmacKeyDerivationFunction;
import software.amazon.encryption.s3.internal.MultipartUploadMaterials;
import software.amazon.encryption.s3.materials.CryptographicMaterials;
import software.amazon.encryption.s3.materials.DecryptionMaterials;
import software.amazon.encryption.s3.materials.EncryptionMaterials;

public class CipherProvider {
    private static byte[] DERIVE_KEY_LABEL_TEMPLATE = "__DERIVEKEY".getBytes(StandardCharsets.UTF_8);
    private static byte[] COMMITKEY_LABEL_TEMPLATE = "__COMMITKEY".getBytes(StandardCharsets.UTF_8);
    private static final byte[] EMPTY_IV = new byte[12];
    private static final byte[] EMPTY_MESSAGE_ID = new byte[28];
    private static final byte[] FIXED_IV_FOR_COMMIT_ALG = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

    public static SecretKey generateDerivedEncryptionKey(CryptographicMaterials materials, byte[] messageId) {
        HmacKeyDerivationFunction kdf;
        String macAlgorithm = materials.algorithmSuite().kdfHashAlgorithm();
        try {
            kdf = HmacKeyDerivationFunction.getInstance(macAlgorithm, materials.cryptoProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        kdf.init(materials.dataKey().getEncoded(), messageId);
        if (materials.dataKey().getEncoded().length != materials.algorithmSuite().dataKeyLengthBytes()) {
            throw new S3EncryptionClientException("Length of Input key material does not match the expected value!");
        }
        if (messageId.length != materials.algorithmSuite().commitmentNonceLengthBytes()) {
            throw new S3EncryptionClientException("Length of Input Message ID does not match the expected value!");
        }
        byte[] commitKeyLabel = (byte[])COMMITKEY_LABEL_TEMPLATE.clone();
        short algId = materials.algorithmSuite().id() == AlgorithmSuite.ALG_AES_256_CTR_HKDF_SHA512_COMMIT_KEY.id() ? (short)AlgorithmSuite.ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY.id() : (short)materials.algorithmSuite().id();
        commitKeyLabel[0] = (byte)(algId >> 8 & 0xFF);
        commitKeyLabel[1] = (byte)(algId & 0xFF);
        byte[] commitment = kdf.deriveKey(commitKeyLabel, materials.algorithmSuite().commitmentLengthBytes());
        if (materials instanceof DecryptionMaterials && !MessageDigest.isEqual(commitment, materials.getKeyCommitment())) {
            throw new S3EncryptionClientSecurityException("Key commitment validation failed. The derived key commitment does not match the stored key commitment value. This indicates potential data tampering or corruption.");
        }
        byte[] deriveKeyLabel = (byte[])DERIVE_KEY_LABEL_TEMPLATE.clone();
        deriveKeyLabel[0] = (byte)(algId >> 8 & 0xFF);
        deriveKeyLabel[1] = (byte)(algId & 0xFF);
        SecretKeySpec ek = new SecretKeySpec(kdf.deriveKey(deriveKeyLabel, materials.algorithmSuite().dataKeyLengthBytes()), materials.algorithmSuite().dataKeyAlgorithm());
        if (materials instanceof EncryptionMaterials) {
            ((EncryptionMaterials)materials).setKeyCommitment(commitment);
        } else if (materials instanceof MultipartUploadMaterials) {
            ((MultipartUploadMaterials)materials).setKeyCommitment(commitment);
        }
        return ek;
    }

    public static Cipher createAndInitCipher(CryptographicMaterials materials, byte[] iv, byte[] messageId) {
        if (iv.length != materials.algorithmSuite().iVLengthBytes()) {
            throw new S3EncryptionClientSecurityException("IV has not been initialized!");
        }
        if (materials.algorithmSuite().isCommitting()) {
            if (MessageDigest.isEqual(messageId, EMPTY_MESSAGE_ID)) {
                throw new S3EncryptionClientSecurityException("MessageId has not been initialized!");
            }
        } else if (MessageDigest.isEqual(iv, EMPTY_IV)) {
            throw new S3EncryptionClientSecurityException("IV has not been initialized!");
        }
        try {
            Cipher cipher = CryptoFactory.createCipher(materials.algorithmSuite().cipherName(), materials.cryptoProvider());
            switch (materials.algorithmSuite()) {
                case ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY: {
                    if (!MessageDigest.isEqual(iv, FIXED_IV_FOR_COMMIT_ALG)) {
                        throw new S3EncryptionClientSecurityException("IV has not been initialized!");
                    }
                    SecretKey actualKey = CipherProvider.generateDerivedEncryptionKey(materials, messageId);
                    cipher.init(materials.cipherMode().opMode(), (Key)actualKey, new GCMParameterSpec(materials.algorithmSuite().cipherTagLengthBits(), iv));
                    cipher.updateAAD(materials.algorithmSuite().idAsBytes());
                    break;
                }
                case ALG_AES_256_GCM_IV12_TAG16_NO_KDF: {
                    cipher.init(materials.cipherMode().opMode(), (Key)materials.dataKey(), new GCMParameterSpec(materials.algorithmSuite().cipherTagLengthBits(), iv));
                    break;
                }
                case ALG_AES_256_CTR_IV16_TAG16_NO_KDF: 
                case ALG_AES_256_CBC_IV16_NO_KDF: {
                    if (materials.cipherMode().opMode() == 1) {
                        throw new S3EncryptionClientException("Encryption is not supported for algorithm: " + materials.algorithmSuite().cipherName());
                    }
                    cipher.init(materials.cipherMode().opMode(), (Key)materials.dataKey(), new IvParameterSpec(iv));
                    break;
                }
                case ALG_AES_256_CTR_HKDF_SHA512_COMMIT_KEY: {
                    if (materials.cipherMode().opMode() == 1) {
                        throw new S3EncryptionClientException("Encryption is not supported for algorithm: " + materials.algorithmSuite().cipherName());
                    }
                    SecretKey actualKey = CipherProvider.generateDerivedEncryptionKey(materials, messageId);
                    cipher.init(materials.cipherMode().opMode(), (Key)actualKey, new IvParameterSpec(iv));
                    break;
                }
                default: {
                    throw new S3EncryptionClientException("Unknown algorithm: " + materials.algorithmSuite().cipherName());
                }
            }
            return cipher;
        }
        catch (Exception exception) {
            throw new S3EncryptionClientException(exception.getMessage(), exception);
        }
    }
}

