/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.ApiName;

public class ApiNameVersion {
    private static final ApiName API_NAME = ApiNameVersion.apiNameWithVersion();
    public static final Consumer<AwsRequestOverrideConfiguration.Builder> API_NAME_INTERCEPTOR = builder -> builder.addApiName(API_NAME);
    public static final String NAME = "AmazonS3Encrypt";
    public static final String API_VERSION_UNKNOWN = "4-unknown";

    public static ApiName apiNameWithVersion() {
        return ApiName.builder().name(NAME).version(ApiNameVersion.apiVersion()).build();
    }

    private static String apiVersion() {
        try {
            String maybeVersion;
            Properties properties = new Properties();
            ClassLoader loader = ApiNameVersion.class.getClassLoader();
            Enumeration<URL> urls = loader.getResources("project.properties");
            if (urls == null) {
                return API_VERSION_UNKNOWN;
            }
            while (urls.hasMoreElements()) {
                URL thisURL = urls.nextElement();
                if (!thisURL.getPath().contains("amazon-s3-encryption-client-java")) continue;
                properties.load(thisURL.openStream());
                break;
            }
            if ((maybeVersion = properties.getProperty("s3ecVersion")) == null) {
                return API_VERSION_UNKNOWN;
            }
            return maybeVersion;
        }
        catch (IOException ex) {
            return API_VERSION_UNKNOWN;
        }
    }
}

