/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;

public class S3EncryptionClientUtilities {
    public static final String DEFAULT_INSTRUCTION_FILE_SUFFIX = ".instruction";
    public static final long MIN_ALLOWED_BUFFER_SIZE_BYTES = AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF.cipherBlockSizeBytes();
    public static final long MAX_ALLOWED_BUFFER_SIZE_BYTES = AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF.cipherMaxContentLengthBytes();
    public static final long DEFAULT_BUFFER_SIZE_BYTES = 0x4000000L;

    static List<ObjectIdentifier> instructionFileKeysToDelete(DeleteObjectsRequest request) {
        return request.delete().objects().stream().map(o -> (ObjectIdentifier)o.toBuilder().key(o.key() + DEFAULT_INSTRUCTION_FILE_SUFFIX).build()).collect(Collectors.toList());
    }
}

