/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.materials;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.internal.CryptoFactory;
import software.amazon.encryption.s3.materials.DataKeyStrategy;
import software.amazon.encryption.s3.materials.DecryptDataKeyStrategy;
import software.amazon.encryption.s3.materials.DecryptionMaterials;
import software.amazon.encryption.s3.materials.EncryptDataKeyStrategy;
import software.amazon.encryption.s3.materials.EncryptionMaterials;
import software.amazon.encryption.s3.materials.GenerateDataKeyStrategy;
import software.amazon.encryption.s3.materials.RawKeyring;

public class AesKeyring
extends RawKeyring<SecretKey> {
    private static final String KEY_ALGORITHM = "AES";
    private final SecretKey _wrappingKey;
    private final DecryptDataKeyStrategy _aesStrategy = new DecryptDataKeyStrategy(){
        private static final String KEY_PROVIDER_INFO = "AES";
        private static final String CIPHER_ALGORITHM = "AES";

        @Override
        public boolean isLegacy() {
            return true;
        }

        @Override
        public String keyProviderInfo() {
            return "AES";
        }

        @Override
        public byte[] decryptDataKey(DecryptionMaterials materials, byte[] encryptedDataKey) throws GeneralSecurityException {
            SecretKey keyToUse = AesKeyring.this.findKeyMaterialForDecryption(materials, AesKeyring.this._wrappingKey);
            Cipher cipher = CryptoFactory.createCipher("AES", materials.cryptoProvider());
            cipher.init(2, keyToUse);
            return cipher.doFinal(encryptedDataKey);
        }
    };
    private final DecryptDataKeyStrategy _aesWrapStrategy = new DecryptDataKeyStrategy(){
        private static final String KEY_PROVIDER_INFO = "AESWrap";
        private static final String CIPHER_ALGORITHM = "AESWrap";

        @Override
        public boolean isLegacy() {
            return true;
        }

        @Override
        public String keyProviderInfo() {
            return "AESWrap";
        }

        @Override
        public byte[] decryptDataKey(DecryptionMaterials materials, byte[] encryptedDataKey) throws GeneralSecurityException {
            SecretKey keyToUse = AesKeyring.this.findKeyMaterialForDecryption(materials, AesKeyring.this._wrappingKey);
            Cipher cipher = CryptoFactory.createCipher("AESWrap", materials.cryptoProvider());
            cipher.init(4, keyToUse);
            Key plaintextKey = cipher.unwrap(encryptedDataKey, "AESWrap", 3);
            return plaintextKey.getEncoded();
        }
    };
    private final DataKeyStrategy _aesGcmStrategy = new DataKeyStrategy(){
        private static final String KEY_PROVIDER_INFO = "AES/GCM";
        private static final String CIPHER_ALGORITHM = "AES/GCM/NoPadding";
        private static final int IV_LENGTH_BYTES = 12;
        private static final int TAG_LENGTH_BYTES = 16;
        private static final int TAG_LENGTH_BITS = 128;

        @Override
        public boolean isLegacy() {
            return false;
        }

        @Override
        public EncryptionMaterials modifyMaterials(EncryptionMaterials materials) {
            return AesKeyring.this.modifyMaterialsForRawKeyring(materials);
        }

        @Override
        public String keyProviderInfo() {
            return KEY_PROVIDER_INFO;
        }

        @Override
        public EncryptionMaterials generateDataKey(EncryptionMaterials materials) {
            return AesKeyring.this.defaultGenerateDataKey(materials);
        }

        @Override
        public byte[] encryptDataKey(SecureRandom secureRandom, EncryptionMaterials materials) throws GeneralSecurityException {
            byte[] iv = new byte[12];
            secureRandom.nextBytes(iv);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            Cipher cipher = CryptoFactory.createCipher(CIPHER_ALGORITHM, materials.cryptoProvider());
            cipher.init(1, (Key)AesKeyring.this._wrappingKey, gcmParameterSpec, secureRandom);
            byte[] aADBytes = AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF.cipherName().getBytes(StandardCharsets.UTF_8);
            cipher.updateAAD(aADBytes);
            byte[] ciphertext = cipher.doFinal(materials.plaintextDataKey());
            byte[] encodedBytes = new byte[iv.length + ciphertext.length];
            System.arraycopy(iv, 0, encodedBytes, 0, iv.length);
            System.arraycopy(ciphertext, 0, encodedBytes, iv.length, ciphertext.length);
            return encodedBytes;
        }

        @Override
        public byte[] decryptDataKey(DecryptionMaterials materials, byte[] encryptedDataKey) throws GeneralSecurityException {
            byte[] iv = new byte[12];
            byte[] ciphertext = new byte[encryptedDataKey.length - iv.length];
            System.arraycopy(encryptedDataKey, 0, iv, 0, iv.length);
            System.arraycopy(encryptedDataKey, iv.length, ciphertext, 0, ciphertext.length);
            SecretKey keyToUse = AesKeyring.this.findKeyMaterialForDecryption(materials, AesKeyring.this._wrappingKey);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            Cipher cipher = CryptoFactory.createCipher(CIPHER_ALGORITHM, materials.cryptoProvider());
            cipher.init(2, (Key)keyToUse, gcmParameterSpec);
            byte[] aADBytes = materials.algorithmSuite().id() == AlgorithmSuite.ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY.id() || materials.algorithmSuite().id() == AlgorithmSuite.ALG_AES_256_CTR_HKDF_SHA512_COMMIT_KEY.id() ? AlgorithmSuite.ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY.idAsString().getBytes(StandardCharsets.UTF_8) : AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF.cipherName().getBytes(StandardCharsets.UTF_8);
            cipher.updateAAD(aADBytes);
            return cipher.doFinal(ciphertext);
        }
    };
    private final Map<String, DecryptDataKeyStrategy> decryptDataKeyStrategies = new HashMap<String, DecryptDataKeyStrategy>();

    private AesKeyring(Builder builder) {
        super(builder);
        this._wrappingKey = builder._wrappingKey;
        this.decryptDataKeyStrategies.put(this._aesStrategy.keyProviderInfo(), this._aesStrategy);
        this.decryptDataKeyStrategies.put(this._aesWrapStrategy.keyProviderInfo(), this._aesWrapStrategy);
        this.decryptDataKeyStrategies.put(this._aesGcmStrategy.keyProviderInfo(), this._aesGcmStrategy);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected GenerateDataKeyStrategy generateDataKeyStrategy() {
        return this._aesGcmStrategy;
    }

    @Override
    protected EncryptDataKeyStrategy encryptDataKeyStrategy() {
        return this._aesGcmStrategy;
    }

    @Override
    protected Map<String, DecryptDataKeyStrategy> decryptDataKeyStrategies() {
        return this.decryptDataKeyStrategies;
    }

    public static class Builder
    extends RawKeyring.Builder<AesKeyring, Builder, SecretKey> {
        private SecretKey _wrappingKey;

        private Builder() {
        }

        @Override
        protected Builder builder() {
            return this;
        }

        public Builder wrappingKey(SecretKey wrappingKey) {
            if (wrappingKey == null) {
                throw new S3EncryptionClientException("Wrapping key cannot be null!");
            }
            if (!wrappingKey.getAlgorithm().equals(AesKeyring.KEY_ALGORITHM)) {
                throw new S3EncryptionClientException("Invalid algorithm: " + wrappingKey.getAlgorithm() + ", expecting " + AesKeyring.KEY_ALGORITHM);
            }
            this._wrappingKey = wrappingKey;
            return this.builder();
        }

        @Override
        public AesKeyring build() {
            return new AesKeyring(this);
        }
    }
}

