/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.internal.AsyncContentEncryptionStrategy;
import software.amazon.encryption.s3.internal.CipherAsyncRequestBody;
import software.amazon.encryption.s3.internal.CipherProvider;
import software.amazon.encryption.s3.internal.EncryptedContent;
import software.amazon.encryption.s3.internal.MultipartContentEncryptionStrategy;
import software.amazon.encryption.s3.internal.MultipartEncryptedContent;
import software.amazon.encryption.s3.materials.EncryptionMaterials;

public class StreamingAesGcmContentStrategy
implements AsyncContentEncryptionStrategy,
MultipartContentEncryptionStrategy {
    private final SecureRandom _secureRandom;

    private StreamingAesGcmContentStrategy(Builder builder) {
        this._secureRandom = builder._secureRandom;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public MultipartEncryptedContent initMultipartEncryption(EncryptionMaterials materials) {
        if (materials.getPlaintextLength() > materials.algorithmSuite().cipherMaxContentLengthBytes()) {
            throw new S3EncryptionClientException("The contentLength of the object you are attempting to encrypt exceedsthe maximum length allowed for GCM encryption.");
        }
        byte[] iv = new byte[materials.algorithmSuite().iVLengthBytes()];
        this._secureRandom.nextBytes(iv);
        Cipher cipher = CipherProvider.createAndInitCipher(materials, iv, null);
        return new MultipartEncryptedContent(iv, null, cipher, materials.getCiphertextLength());
    }

    @Override
    public EncryptedContent encryptContent(EncryptionMaterials materials, AsyncRequestBody content) {
        if (materials.getPlaintextLength() > materials.algorithmSuite().cipherMaxContentLengthBytes()) {
            throw new S3EncryptionClientException("The contentLength of the object you are attempting to encrypt exceedsthe maximum length allowed for GCM encryption.");
        }
        byte[] iv = new byte[materials.algorithmSuite().iVLengthBytes()];
        this._secureRandom.nextBytes(iv);
        CipherAsyncRequestBody encryptedAsyncRequestBody = new CipherAsyncRequestBody(content, materials.getCiphertextLength(), materials, iv, null);
        return new EncryptedContent(iv, null, encryptedAsyncRequestBody, materials.getCiphertextLength());
    }

    public static class Builder {
        private SecureRandom _secureRandom = new SecureRandom();

        private Builder() {
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public Builder secureRandom(SecureRandom secureRandom) {
            if (secureRandom == null) {
                throw new S3EncryptionClientException("SecureRandom provided to StreamingAesGcmContentStrategy cannot be null");
            }
            this._secureRandom = secureRandom;
            return this;
        }

        public StreamingAesGcmContentStrategy build() {
            return new StreamingAesGcmContentStrategy(this);
        }
    }
}

