/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class HmacKeyDerivationFunction {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private final String algorithm;
    private final Provider provider;
    private SecretKey prk = null;

    public static HmacKeyDerivationFunction getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Mac mac = provider != null ? Mac.getInstance(algorithm, provider) : Mac.getInstance(algorithm);
        return new HmacKeyDerivationFunction(algorithm, mac.getProvider());
    }

    public void init(byte[] ikm) {
        this.init(ikm, null);
    }

    public void init(byte[] ikm, byte[] salt) {
        byte[] realSalt = salt == null ? EMPTY_ARRAY : (byte[])salt.clone();
        byte[] rawKeyMaterial = EMPTY_ARRAY;
        try {
            Mac extractionMac = Mac.getInstance(this.algorithm, this.provider);
            if (realSalt.length == 0) {
                realSalt = new byte[extractionMac.getMacLength()];
                Arrays.fill(realSalt, (byte)0);
            }
            extractionMac.init(new SecretKeySpec(realSalt, this.algorithm));
            rawKeyMaterial = extractionMac.doFinal(ikm);
            this.prk = new SecretKeySpec(rawKeyMaterial, this.algorithm);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        finally {
            Arrays.fill(rawKeyMaterial, (byte)0);
        }
    }

    private void isTrue(boolean expression, String message, Object ... values) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }

    private HmacKeyDerivationFunction(String algorithm, Provider provider) {
        this.isTrue(algorithm.startsWith("Hmac"), "Invalid algorithm " + algorithm + ". Hkdf may only be used with Hmac algorithms.", new Object[0]);
        this.algorithm = algorithm;
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] deriveKey(byte[] info, int length) throws IllegalStateException {
        this.isTrue(length >= 0, "Length must be a non-negative value.", new Object[0]);
        this.assertInitialized();
        byte[] result = new byte[length];
        Mac mac = this.createMac();
        this.isTrue(length <= 255 * mac.getMacLength(), "Requested keys may not be longer than 255 times the underlying HMAC length.", new Object[0]);
        byte[] t = EMPTY_ARRAY;
        try {
            int loc = 0;
            byte i = 1;
            while (loc < length) {
                mac.update(t);
                mac.update(info);
                mac.update(i);
                t = mac.doFinal();
                for (int x = 0; x < t.length && loc < length; ++x, ++loc) {
                    result[loc] = t[x];
                }
                i = (byte)(i + 1);
            }
        }
        finally {
            Arrays.fill(t, (byte)0);
        }
        return result;
    }

    private Mac createMac() {
        try {
            Mac mac = Mac.getInstance(this.algorithm, this.provider);
            mac.init(this.prk);
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void assertInitialized() throws IllegalStateException {
        if (this.prk == null) {
            throw new IllegalStateException("Hkdf has not been initialized");
        }
    }
}

