/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import software.amazon.awssdk.core.io.SdkFilterInputStream;

public class CipherInputStream
extends SdkFilterInputStream {
    private static final int MAX_RETRY_COUNT = 1000;
    private static final int DEFAULT_IN_BUFFER_SIZE = 512;
    protected final Cipher cipher;
    protected boolean eofReached;
    protected byte[] inputBuffer;
    protected byte[] outputBuffer;
    protected int currentPosition;
    protected int maxPosition;

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        this.cipher = cipher;
        this.inputBuffer = new byte[512];
    }

    public int read() throws IOException {
        if (!this.readNextChunk()) {
            return -1;
        }
        return this.outputBuffer[this.currentPosition++] & 0xFF;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int off, int targetLength) throws IOException {
        if (!this.readNextChunk()) {
            return -1;
        }
        if (targetLength <= 0) {
            return 0;
        }
        int length = this.maxPosition - this.currentPosition;
        if (targetLength < length) {
            length = targetLength;
        }
        System.arraycopy(this.outputBuffer, this.currentPosition, buffer, off, length);
        this.currentPosition += length;
        return length;
    }

    private boolean readNextChunk() throws IOException {
        if (this.currentPosition >= this.maxPosition) {
            int length;
            if (this.eofReached) {
                return false;
            }
            int retryCount = 0;
            do {
                if (retryCount > 1000) {
                    throw new IOException("Exceeded maximum number of attempts to read next chunk of data");
                }
                length = this.nextChunk();
                if (this.outputBuffer != null) continue;
                ++retryCount;
            } while (length == 0);
            if (length == -1) {
                return false;
            }
        }
        return true;
    }

    public long skip(long n) {
        this.abortIfNeeded();
        int available = this.maxPosition - this.currentPosition;
        if (n > (long)available) {
            n = available;
        }
        if (n < 0L) {
            return 0L;
        }
        this.currentPosition = (int)((long)this.currentPosition + n);
        return n;
    }

    public int available() {
        this.abortIfNeeded();
        return this.maxPosition - this.currentPosition;
    }

    public void close() throws IOException {
        this.in.close();
        try {
            this.cipher.doFinal();
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            // empty catch block
        }
        this.maxPosition = 0;
        this.currentPosition = 0;
        this.abortIfNeeded();
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    protected int nextChunk() throws IOException {
        this.abortIfNeeded();
        if (this.eofReached) {
            return -1;
        }
        this.outputBuffer = null;
        int length = this.in.read(this.inputBuffer);
        if (length == -1) {
            return this.endOfFileReached();
        }
        this.outputBuffer = this.cipher.update(this.inputBuffer, 0, length);
        this.currentPosition = 0;
        this.maxPosition = this.outputBuffer == null ? 0 : this.outputBuffer.length;
        return this.maxPosition;
    }

    protected int endOfFileReached() {
        this.eofReached = true;
        try {
            this.outputBuffer = this.cipher.doFinal();
            if (this.outputBuffer == null) {
                return -1;
            }
            this.currentPosition = 0;
            this.maxPosition = this.outputBuffer.length;
            return this.maxPosition;
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            return -1;
        }
    }
}

