/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.encryption.s3.internal.BufferedCipherSubscriber;
import software.amazon.encryption.s3.materials.CryptographicMaterials;

public class BufferedCipherPublisher
implements SdkPublisher<ByteBuffer> {
    private final SdkPublisher<ByteBuffer> wrappedPublisher;
    private final Long contentLength;
    private final CryptographicMaterials materials;
    private final byte[] iv;
    private final long bufferSize;

    public BufferedCipherPublisher(SdkPublisher<ByteBuffer> wrappedPublisher, Long contentLength, CryptographicMaterials materials, byte[] iv, long bufferSize) {
        this.wrappedPublisher = wrappedPublisher;
        this.contentLength = contentLength;
        this.materials = materials;
        this.iv = iv;
        this.bufferSize = bufferSize;
    }

    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        this.wrappedPublisher.subscribe((Subscriber)new BufferedCipherSubscriber(subscriber, this.contentLength, this.materials, this.iv, this.bufferSize));
    }
}

