/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.internal.CipherSubscriber;
import software.amazon.encryption.s3.materials.CryptographicMaterials;

public class CipherAsyncRequestBody
implements AsyncRequestBody {
    private final AsyncRequestBody wrappedAsyncRequestBody;
    private final Long ciphertextLength;
    private final CryptographicMaterials materials;
    private final byte[] iv;
    private final boolean isLastPart;

    public CipherAsyncRequestBody(AsyncRequestBody wrappedAsyncRequestBody, Long ciphertextLength, CryptographicMaterials materials, byte[] iv, boolean isLastPart) {
        this.wrappedAsyncRequestBody = wrappedAsyncRequestBody;
        this.ciphertextLength = ciphertextLength;
        this.materials = materials;
        this.iv = iv;
        this.isLastPart = isLastPart;
    }

    public CipherAsyncRequestBody(AsyncRequestBody wrappedAsyncRequestBody, Long ciphertextLength, CryptographicMaterials materials, byte[] iv) {
        this(wrappedAsyncRequestBody, ciphertextLength, materials, iv, true);
    }

    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        this.wrappedAsyncRequestBody.subscribe((Subscriber)new CipherSubscriber(subscriber, this.contentLength().orElseThrow(() -> new S3EncryptionClientException("Unbounded streams are currently not supported.")), this.materials, this.iv, this.isLastPart));
    }

    public Optional<Long> contentLength() {
        return Optional.of(this.ciphertextLength);
    }
}

