/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.materials;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.materials.PartialKeyPair;

public class PartialRsaKeyPair
implements PartialKeyPair {
    private final PrivateKey _privateKey;
    private final PublicKey _publicKey;
    private static final String RSA_KEY_ALGORITHM = "RSA";

    public PartialRsaKeyPair(KeyPair keyPair) {
        this._privateKey = keyPair.getPrivate();
        this._publicKey = keyPair.getPublic();
        this.validateKeyPair();
    }

    public PartialRsaKeyPair(PrivateKey privateKey, PublicKey publicKey) {
        this._privateKey = privateKey;
        this._publicKey = publicKey;
        this.validateKeyPair();
    }

    private void validateKeyPair() {
        if (this._privateKey == null && this._publicKey == null) {
            throw new S3EncryptionClientException("The public key and private cannot both be null. You must provide a public key, or a private key, or both.");
        }
        if (this._privateKey != null && !this._privateKey.getAlgorithm().equals(RSA_KEY_ALGORITHM)) {
            throw new S3EncryptionClientException("%s is not a supported algorithm. Only RSA keys are supported. Please reconfigure your client with an RSA key.");
        }
        if (this._publicKey != null && !this._publicKey.getAlgorithm().equals(RSA_KEY_ALGORITHM)) {
            throw new S3EncryptionClientException("%s is not a supported algorithm. Only RSA keys are supported. Please reconfigure your client with an RSA key.");
        }
    }

    @Override
    public PublicKey getPublicKey() {
        if (this._publicKey == null) {
            throw new S3EncryptionClientException("No public key provided. You must configure a public key to be able to encrypt data.");
        }
        return this._publicKey;
    }

    @Override
    public PrivateKey getPrivateKey() {
        if (this._privateKey == null) {
            throw new S3EncryptionClientException("No private key provided. You must configure a private key to be able to decrypt data.");
        }
        return this._privateKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartialRsaKeyPair that = (PartialRsaKeyPair)o;
        return Objects.equals(this._privateKey, that._privateKey) && Objects.equals(this._publicKey, that._publicKey);
    }

    public int hashCode() {
        return Objects.hash(this._privateKey, this._publicKey);
    }

    public static class Builder {
        private PublicKey _publicKey;
        private PrivateKey _privateKey;

        private Builder() {
        }

        public Builder publicKey(PublicKey publicKey) {
            this._publicKey = publicKey;
            return this;
        }

        public Builder privateKey(PrivateKey privateKey) {
            this._privateKey = privateKey;
            return this;
        }

        public PartialRsaKeyPair build() {
            return new PartialRsaKeyPair(this._privateKey, this._publicKey);
        }
    }
}

