/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.security.KeyPair;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.crypto.SecretKey;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.config.ClientAsyncConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.s3.DelegatingS3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.internal.crt.S3CrtAsyncClient;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.encryption.s3.S3EncryptionClient;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.S3EncryptionClientUtilities;
import software.amazon.encryption.s3.internal.ApiNameVersion;
import software.amazon.encryption.s3.internal.GetEncryptedObjectPipeline;
import software.amazon.encryption.s3.internal.NoRetriesAsyncRequestBody;
import software.amazon.encryption.s3.internal.PutEncryptedObjectPipeline;
import software.amazon.encryption.s3.materials.AesKeyring;
import software.amazon.encryption.s3.materials.CryptographicMaterialsManager;
import software.amazon.encryption.s3.materials.DefaultCryptoMaterialsManager;
import software.amazon.encryption.s3.materials.Keyring;
import software.amazon.encryption.s3.materials.KmsKeyring;
import software.amazon.encryption.s3.materials.PartialRsaKeyPair;
import software.amazon.encryption.s3.materials.RsaKeyring;

public class S3AsyncEncryptionClient
extends DelegatingS3AsyncClient {
    private final S3AsyncClient _wrappedClient;
    private final CryptographicMaterialsManager _cryptoMaterialsManager;
    private final SecureRandom _secureRandom;
    private final boolean _enableLegacyUnauthenticatedModes;
    private final boolean _enableDelayedAuthenticationMode;
    private final boolean _enableMultipartPutObject;
    private final long _bufferSize;

    private S3AsyncEncryptionClient(Builder builder) {
        super(builder._wrappedClient);
        this._wrappedClient = builder._wrappedClient;
        this._cryptoMaterialsManager = builder._cryptoMaterialsManager;
        this._secureRandom = builder._secureRandom;
        this._enableLegacyUnauthenticatedModes = builder._enableLegacyUnauthenticatedModes;
        this._enableDelayedAuthenticationMode = builder._enableDelayedAuthenticationMode;
        this._enableMultipartPutObject = builder._enableMultipartPutObject;
        this._bufferSize = builder._bufferSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Consumer<AwsRequestOverrideConfiguration.Builder> withAdditionalEncryptionContext(Map<String, String> encryptionContext) {
        return builder -> builder.putExecutionAttribute(S3EncryptionClient.ENCRYPTION_CONTEXT, (Object)encryptionContext);
    }

    public CompletableFuture<PutObjectResponse> putObject(PutObjectRequest putObjectRequest, AsyncRequestBody requestBody) throws AwsServiceException, SdkClientException {
        if (this._enableMultipartPutObject) {
            return this.multipartPutObject(putObjectRequest, requestBody);
        }
        PutEncryptedObjectPipeline pipeline = PutEncryptedObjectPipeline.builder().s3AsyncClient(this._wrappedClient).cryptoMaterialsManager(this._cryptoMaterialsManager).secureRandom(this._secureRandom).build();
        return pipeline.putObject(putObjectRequest, requestBody);
    }

    private CompletableFuture<PutObjectResponse> multipartPutObject(PutObjectRequest putObjectRequest, AsyncRequestBody requestBody) {
        S3AsyncClient crtClient = this._wrappedClient instanceof S3CrtAsyncClient ? this._wrappedClient : S3AsyncClient.crtCreate();
        PutEncryptedObjectPipeline pipeline = PutEncryptedObjectPipeline.builder().s3AsyncClient(crtClient).cryptoMaterialsManager(this._cryptoMaterialsManager).secureRandom(this._secureRandom).build();
        NoRetriesAsyncRequestBody noRetryBody = new NoRetriesAsyncRequestBody(requestBody);
        return pipeline.putObject(putObjectRequest, noRetryBody);
    }

    public <T> CompletableFuture<T> getObject(GetObjectRequest getObjectRequest, AsyncResponseTransformer<GetObjectResponse, T> asyncResponseTransformer) {
        GetEncryptedObjectPipeline pipeline = GetEncryptedObjectPipeline.builder().s3AsyncClient(this._wrappedClient).cryptoMaterialsManager(this._cryptoMaterialsManager).enableLegacyUnauthenticatedModes(this._enableLegacyUnauthenticatedModes).enableDelayedAuthentication(this._enableDelayedAuthenticationMode).bufferSize(this._bufferSize).build();
        return pipeline.getObject(getObjectRequest, asyncResponseTransformer);
    }

    public CompletableFuture<DeleteObjectResponse> deleteObject(DeleteObjectRequest deleteObjectRequest) {
        DeleteObjectRequest actualRequest = (DeleteObjectRequest)deleteObjectRequest.toBuilder().overrideConfiguration(ApiNameVersion.API_NAME_INTERCEPTOR).build();
        CompletableFuture response = this._wrappedClient.deleteObject(actualRequest);
        String instructionObjectKey = deleteObjectRequest.key() + ".instruction";
        CompletableFuture instructionResponse = this._wrappedClient.deleteObject(builder -> builder.overrideConfiguration(ApiNameVersion.API_NAME_INTERCEPTOR).bucket(deleteObjectRequest.bucket()).key(instructionObjectKey));
        Function<DeleteObjectResponse, DeleteObjectResponse> deletion = deleteObjectResponse -> (DeleteObjectResponse)response.join();
        return instructionResponse.thenApplyAsync(deletion);
    }

    public CompletableFuture<DeleteObjectsResponse> deleteObjects(DeleteObjectsRequest deleteObjectsRequest) throws AwsServiceException, SdkClientException {
        List<ObjectIdentifier> objectsToDelete = S3EncryptionClientUtilities.instructionFileKeysToDelete(deleteObjectsRequest);
        objectsToDelete.addAll(deleteObjectsRequest.delete().objects());
        return this._wrappedClient.deleteObjects((DeleteObjectsRequest)deleteObjectsRequest.toBuilder().overrideConfiguration(ApiNameVersion.API_NAME_INTERCEPTOR).delete(builder -> builder.objects((Collection)objectsToDelete)).build());
    }

    public void close() {
        this._wrappedClient.close();
    }

    public static class Builder
    implements S3AsyncClientBuilder {
        private S3AsyncClient _wrappedClient;
        private CryptographicMaterialsManager _cryptoMaterialsManager;
        private Keyring _keyring;
        private SecretKey _aesKey;
        private PartialRsaKeyPair _rsaKeyPair;
        private String _kmsKeyId;
        private boolean _enableLegacyWrappingAlgorithms = false;
        private boolean _enableLegacyUnauthenticatedModes = false;
        private boolean _enableDelayedAuthenticationMode = false;
        private boolean _enableMultipartPutObject = false;
        private Provider _cryptoProvider = null;
        private SecureRandom _secureRandom = new SecureRandom();
        private long _bufferSize = -1L;
        private AwsCredentialsProvider _awsCredentialsProvider = null;
        private Region _region = null;
        private boolean _dualStackEnabled = false;
        private boolean _fipsEnabled = false;
        private ClientOverrideConfiguration _overrideConfiguration = null;
        private URI _endpointOverride = null;
        private ClientAsyncConfiguration _clientAsyncConfiguration = null;
        private SdkAsyncHttpClient _sdkAsyncHttpClient = null;
        private SdkAsyncHttpClient.Builder _sdkAsyncHttpClientBuilder = null;
        private S3Configuration _serviceConfiguration = null;
        private Boolean _accelerate = null;
        private Boolean _disableMultiRegionAccessPoints = null;
        private Boolean _forcePathStyle = null;
        private Boolean _useArnRegion = null;

        private Builder() {
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Pass mutability into wrapping client")
        public Builder wrappedClient(S3AsyncClient wrappedClient) {
            if (wrappedClient instanceof S3AsyncEncryptionClient) {
                throw new S3EncryptionClientException("Cannot use S3EncryptionClient as wrapped client");
            }
            this._wrappedClient = wrappedClient;
            return this;
        }

        public Builder cryptoMaterialsManager(CryptographicMaterialsManager cryptoMaterialsManager) {
            this._cryptoMaterialsManager = cryptoMaterialsManager;
            this.checkKeyOptions();
            return this;
        }

        public Builder keyring(Keyring keyring) {
            this._keyring = keyring;
            this.checkKeyOptions();
            return this;
        }

        public Builder aesKey(SecretKey aesKey) {
            this._aesKey = aesKey;
            this.checkKeyOptions();
            return this;
        }

        public Builder rsaKeyPair(KeyPair rsaKeyPair) {
            this._rsaKeyPair = new PartialRsaKeyPair(rsaKeyPair);
            this.checkKeyOptions();
            return this;
        }

        public Builder rsaKeyPair(PartialRsaKeyPair partialRsaKeyPair) {
            this._rsaKeyPair = partialRsaKeyPair;
            this.checkKeyOptions();
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this._kmsKeyId = kmsKeyId;
            this.checkKeyOptions();
            return this;
        }

        private void checkKeyOptions() {
            if (this.onlyOneNonNull(this._cryptoMaterialsManager, this._keyring, this._aesKey, this._rsaKeyPair, this._kmsKeyId)) {
                return;
            }
            throw new S3EncryptionClientException("Only one may be set of: crypto materials manager, keyring, AES key, RSA key pair, KMS key id");
        }

        private boolean onlyOneNonNull(Object ... values) {
            boolean haveOneNonNull = false;
            for (Object o : values) {
                if (o == null) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }

        public Builder enableLegacyWrappingAlgorithms(boolean shouldEnableLegacyWrappingAlgorithms) {
            this._enableLegacyWrappingAlgorithms = shouldEnableLegacyWrappingAlgorithms;
            return this;
        }

        public Builder enableLegacyUnauthenticatedModes(boolean shouldEnableLegacyUnauthenticatedModes) {
            this._enableLegacyUnauthenticatedModes = shouldEnableLegacyUnauthenticatedModes;
            return this;
        }

        public Builder enableDelayedAuthenticationMode(boolean shouldEnableDelayedAuthenticationMode) {
            this._enableDelayedAuthenticationMode = shouldEnableDelayedAuthenticationMode;
            return this;
        }

        public Builder enableMultipartPutObject(boolean _enableMultipartPutObject) {
            this._enableMultipartPutObject = _enableMultipartPutObject;
            return this;
        }

        public Builder setBufferSize(long bufferSize) {
            if (bufferSize < S3EncryptionClientUtilities.MIN_ALLOWED_BUFFER_SIZE_BYTES || bufferSize > S3EncryptionClientUtilities.MAX_ALLOWED_BUFFER_SIZE_BYTES) {
                throw new S3EncryptionClientException("Invalid buffer size: " + bufferSize + " Bytes. Buffer size must be between " + S3EncryptionClientUtilities.MIN_ALLOWED_BUFFER_SIZE_BYTES + " and " + S3EncryptionClientUtilities.MAX_ALLOWED_BUFFER_SIZE_BYTES + " Bytes.");
            }
            this._bufferSize = bufferSize;
            return this;
        }

        public Builder cryptoProvider(Provider cryptoProvider) {
            this._cryptoProvider = cryptoProvider;
            return this;
        }

        public Builder secureRandom(SecureRandom secureRandom) {
            if (secureRandom == null) {
                throw new S3EncryptionClientException("SecureRandom provided to S3EncryptionClient cannot be null");
            }
            this._secureRandom = secureRandom;
            return this;
        }

        public Builder credentialsProvider(AwsCredentialsProvider awsCredentialsProvider) {
            this._awsCredentialsProvider = awsCredentialsProvider;
            return this;
        }

        public Builder region(Region region) {
            this._region = region;
            return this;
        }

        public Builder dualstackEnabled(Boolean isDualStackEnabled) {
            this._dualStackEnabled = Optional.ofNullable(isDualStackEnabled).orElse(Boolean.FALSE);
            return this;
        }

        public Builder fipsEnabled(Boolean isFipsEnabled) {
            this._fipsEnabled = Optional.ofNullable(isFipsEnabled).orElse(Boolean.FALSE);
            return this;
        }

        public Builder overrideConfiguration(ClientOverrideConfiguration overrideConfiguration) {
            this._overrideConfiguration = overrideConfiguration;
            return this;
        }

        public ClientOverrideConfiguration overrideConfiguration() {
            return this._overrideConfiguration;
        }

        public Builder endpointOverride(URI endpointOverride) {
            this._endpointOverride = endpointOverride;
            return this;
        }

        public Builder asyncConfiguration(ClientAsyncConfiguration clientAsyncConfiguration) {
            this._clientAsyncConfiguration = clientAsyncConfiguration;
            return this;
        }

        public Builder httpClient(SdkAsyncHttpClient httpClient) {
            this._sdkAsyncHttpClient = httpClient;
            return this;
        }

        public Builder httpClientBuilder(SdkAsyncHttpClient.Builder httpClientBuilder) {
            this._sdkAsyncHttpClientBuilder = httpClientBuilder;
            return this;
        }

        public Builder serviceConfiguration(S3Configuration serviceConfiguration) {
            this._serviceConfiguration = serviceConfiguration;
            return this;
        }

        public Builder accelerate(Boolean accelerate) {
            this._accelerate = accelerate;
            return this;
        }

        public Builder disableMultiRegionAccessPoints(Boolean disableMultiRegionAccessPoints) {
            this._disableMultiRegionAccessPoints = disableMultiRegionAccessPoints;
            return this;
        }

        public Builder forcePathStyle(Boolean forcePathStyle) {
            this._forcePathStyle = forcePathStyle;
            return this;
        }

        public Builder useArnRegion(Boolean useArnRegion) {
            this._useArnRegion = useArnRegion;
            return this;
        }

        public S3AsyncEncryptionClient build() {
            if (!this.onlyOneNonNull(this._cryptoMaterialsManager, this._keyring, this._aesKey, this._rsaKeyPair, this._kmsKeyId)) {
                throw new S3EncryptionClientException("Exactly one must be set of: crypto materials manager, keyring, AES key, RSA key pair, KMS key id");
            }
            if (this._bufferSize >= 0L) {
                if (this._enableDelayedAuthenticationMode) {
                    throw new S3EncryptionClientException("Buffer size cannot be set when delayed authentication mode is enabled");
                }
            } else {
                this._bufferSize = 0x4000000L;
            }
            if (this._wrappedClient == null) {
                this._wrappedClient = (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().credentialsProvider(this._awsCredentialsProvider)).region(this._region)).dualstackEnabled(Boolean.valueOf(this._dualStackEnabled))).fipsEnabled(Boolean.valueOf(this._fipsEnabled))).overrideConfiguration(this._overrideConfiguration)).endpointOverride(this._endpointOverride)).asyncConfiguration(this._clientAsyncConfiguration != null ? this._clientAsyncConfiguration : (ClientAsyncConfiguration)ClientAsyncConfiguration.builder().build())).httpClient(this._sdkAsyncHttpClient)).httpClientBuilder(this._sdkAsyncHttpClientBuilder)).serviceConfiguration(this._serviceConfiguration)).accelerate(this._accelerate)).disableMultiRegionAccessPoints(this._disableMultiRegionAccessPoints)).forcePathStyle(this._forcePathStyle)).useArnRegion(this._useArnRegion)).build();
            }
            if (this._keyring == null) {
                if (this._aesKey != null) {
                    this._keyring = ((AesKeyring.Builder)((AesKeyring.Builder)AesKeyring.builder().wrappingKey(this._aesKey).enableLegacyWrappingAlgorithms(this._enableLegacyWrappingAlgorithms)).secureRandom(this._secureRandom)).build();
                } else if (this._rsaKeyPair != null) {
                    this._keyring = ((RsaKeyring.Builder)((RsaKeyring.Builder)RsaKeyring.builder().wrappingKeyPair(this._rsaKeyPair).enableLegacyWrappingAlgorithms(this._enableLegacyWrappingAlgorithms)).secureRandom(this._secureRandom)).build();
                } else if (this._kmsKeyId != null) {
                    KmsClient kmsClient = (KmsClient)((KmsClientBuilder)((KmsClientBuilder)((KmsClientBuilder)((KmsClientBuilder)((KmsClientBuilder)KmsClient.builder().credentialsProvider(this._awsCredentialsProvider)).region(this._region)).dualstackEnabled(Boolean.valueOf(this._dualStackEnabled))).fipsEnabled(Boolean.valueOf(this._fipsEnabled))).overrideConfiguration(this._overrideConfiguration)).build();
                    this._keyring = ((KmsKeyring.Builder)((KmsKeyring.Builder)KmsKeyring.builder().kmsClient(kmsClient).wrappingKeyId(this._kmsKeyId).enableLegacyWrappingAlgorithms(this._enableLegacyWrappingAlgorithms)).secureRandom(this._secureRandom)).build();
                }
            }
            if (this._cryptoMaterialsManager == null) {
                this._cryptoMaterialsManager = DefaultCryptoMaterialsManager.builder().keyring(this._keyring).cryptoProvider(this._cryptoProvider).build();
            }
            return new S3AsyncEncryptionClient(this);
        }
    }
}

