/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProbabilisticRuleValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProbabilisticRuleValue> {
    private static final SdkField<Double> DESIRED_SAMPLING_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DesiredSamplingPercentage").getter(ProbabilisticRuleValue.getter(ProbabilisticRuleValue::desiredSamplingPercentage)).setter(ProbabilisticRuleValue.setter(Builder::desiredSamplingPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredSamplingPercentage").build()}).build();
    private static final SdkField<Double> ACTUAL_SAMPLING_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ActualSamplingPercentage").getter(ProbabilisticRuleValue.getter(ProbabilisticRuleValue::actualSamplingPercentage)).setter(ProbabilisticRuleValue.setter(Builder::actualSamplingPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualSamplingPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_SAMPLING_PERCENTAGE_FIELD, ACTUAL_SAMPLING_PERCENTAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProbabilisticRuleValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double desiredSamplingPercentage;
    private final Double actualSamplingPercentage;

    private ProbabilisticRuleValue(BuilderImpl builder) {
        this.desiredSamplingPercentage = builder.desiredSamplingPercentage;
        this.actualSamplingPercentage = builder.actualSamplingPercentage;
    }

    public final Double desiredSamplingPercentage() {
        return this.desiredSamplingPercentage;
    }

    public final Double actualSamplingPercentage() {
        return this.actualSamplingPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredSamplingPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualSamplingPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProbabilisticRuleValue)) {
            return false;
        }
        ProbabilisticRuleValue other = (ProbabilisticRuleValue)obj;
        return Objects.equals(this.desiredSamplingPercentage(), other.desiredSamplingPercentage()) && Objects.equals(this.actualSamplingPercentage(), other.actualSamplingPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"ProbabilisticRuleValue").add("DesiredSamplingPercentage", (Object)this.desiredSamplingPercentage()).add("ActualSamplingPercentage", (Object)this.actualSamplingPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DesiredSamplingPercentage": {
                return Optional.ofNullable(clazz.cast(this.desiredSamplingPercentage()));
            }
            case "ActualSamplingPercentage": {
                return Optional.ofNullable(clazz.cast(this.actualSamplingPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Double>> map = new HashMap<String, SdkField<Double>>();
        map.put("DesiredSamplingPercentage", DESIRED_SAMPLING_PERCENTAGE_FIELD);
        map.put("ActualSamplingPercentage", ACTUAL_SAMPLING_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProbabilisticRuleValue, T> g) {
        return obj -> g.apply((ProbabilisticRuleValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double desiredSamplingPercentage;
        private Double actualSamplingPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(ProbabilisticRuleValue model) {
            this.desiredSamplingPercentage(model.desiredSamplingPercentage);
            this.actualSamplingPercentage(model.actualSamplingPercentage);
        }

        public final Double getDesiredSamplingPercentage() {
            return this.desiredSamplingPercentage;
        }

        public final void setDesiredSamplingPercentage(Double desiredSamplingPercentage) {
            this.desiredSamplingPercentage = desiredSamplingPercentage;
        }

        @Override
        public final Builder desiredSamplingPercentage(Double desiredSamplingPercentage) {
            this.desiredSamplingPercentage = desiredSamplingPercentage;
            return this;
        }

        public final Double getActualSamplingPercentage() {
            return this.actualSamplingPercentage;
        }

        public final void setActualSamplingPercentage(Double actualSamplingPercentage) {
            this.actualSamplingPercentage = actualSamplingPercentage;
        }

        @Override
        public final Builder actualSamplingPercentage(Double actualSamplingPercentage) {
            this.actualSamplingPercentage = actualSamplingPercentage;
            return this;
        }

        public ProbabilisticRuleValue build() {
            return new ProbabilisticRuleValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProbabilisticRuleValue> {
        public Builder desiredSamplingPercentage(Double var1);

        public Builder actualSamplingPercentage(Double var1);
    }
}

