/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.SamplingTargetDocument;
import software.amazon.awssdk.services.xray.model.SamplingTargetDocumentListCopier;
import software.amazon.awssdk.services.xray.model.UnprocessedStatistics;
import software.amazon.awssdk.services.xray.model.UnprocessedStatisticsListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSamplingTargetsResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, GetSamplingTargetsResponse> {
    private static final SdkField<List<SamplingTargetDocument>> SAMPLING_TARGET_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SamplingTargetDocuments").getter(GetSamplingTargetsResponse.getter(GetSamplingTargetsResponse::samplingTargetDocuments)).setter(GetSamplingTargetsResponse.setter(Builder::samplingTargetDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingTargetDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SamplingTargetDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_RULE_MODIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastRuleModification").getter(GetSamplingTargetsResponse.getter(GetSamplingTargetsResponse::lastRuleModification)).setter(GetSamplingTargetsResponse.setter(Builder::lastRuleModification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRuleModification").build()}).build();
    private static final SdkField<List<UnprocessedStatistics>> UNPROCESSED_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedStatistics").getter(GetSamplingTargetsResponse.getter(GetSamplingTargetsResponse::unprocessedStatistics)).setter(GetSamplingTargetsResponse.setter(Builder::unprocessedStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedStatistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedStatistics>> UNPROCESSED_BOOST_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedBoostStatistics").getter(GetSamplingTargetsResponse.getter(GetSamplingTargetsResponse::unprocessedBoostStatistics)).setter(GetSamplingTargetsResponse.setter(Builder::unprocessedBoostStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedBoostStatistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLING_TARGET_DOCUMENTS_FIELD, LAST_RULE_MODIFICATION_FIELD, UNPROCESSED_STATISTICS_FIELD, UNPROCESSED_BOOST_STATISTICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSamplingTargetsResponse.memberNameToFieldInitializer();
    private final List<SamplingTargetDocument> samplingTargetDocuments;
    private final Instant lastRuleModification;
    private final List<UnprocessedStatistics> unprocessedStatistics;
    private final List<UnprocessedStatistics> unprocessedBoostStatistics;

    private GetSamplingTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.samplingTargetDocuments = builder.samplingTargetDocuments;
        this.lastRuleModification = builder.lastRuleModification;
        this.unprocessedStatistics = builder.unprocessedStatistics;
        this.unprocessedBoostStatistics = builder.unprocessedBoostStatistics;
    }

    public final boolean hasSamplingTargetDocuments() {
        return this.samplingTargetDocuments != null && !(this.samplingTargetDocuments instanceof SdkAutoConstructList);
    }

    public final List<SamplingTargetDocument> samplingTargetDocuments() {
        return this.samplingTargetDocuments;
    }

    public final Instant lastRuleModification() {
        return this.lastRuleModification;
    }

    public final boolean hasUnprocessedStatistics() {
        return this.unprocessedStatistics != null && !(this.unprocessedStatistics instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedStatistics> unprocessedStatistics() {
        return this.unprocessedStatistics;
    }

    public final boolean hasUnprocessedBoostStatistics() {
        return this.unprocessedBoostStatistics != null && !(this.unprocessedBoostStatistics instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedStatistics> unprocessedBoostStatistics() {
        return this.unprocessedBoostStatistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSamplingTargetDocuments() ? this.samplingTargetDocuments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRuleModification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedStatistics() ? this.unprocessedStatistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedBoostStatistics() ? this.unprocessedBoostStatistics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSamplingTargetsResponse)) {
            return false;
        }
        GetSamplingTargetsResponse other = (GetSamplingTargetsResponse)((Object)obj);
        return this.hasSamplingTargetDocuments() == other.hasSamplingTargetDocuments() && Objects.equals(this.samplingTargetDocuments(), other.samplingTargetDocuments()) && Objects.equals(this.lastRuleModification(), other.lastRuleModification()) && this.hasUnprocessedStatistics() == other.hasUnprocessedStatistics() && Objects.equals(this.unprocessedStatistics(), other.unprocessedStatistics()) && this.hasUnprocessedBoostStatistics() == other.hasUnprocessedBoostStatistics() && Objects.equals(this.unprocessedBoostStatistics(), other.unprocessedBoostStatistics());
    }

    public final String toString() {
        return ToString.builder((String)"GetSamplingTargetsResponse").add("SamplingTargetDocuments", this.hasSamplingTargetDocuments() ? this.samplingTargetDocuments() : null).add("LastRuleModification", (Object)this.lastRuleModification()).add("UnprocessedStatistics", this.hasUnprocessedStatistics() ? this.unprocessedStatistics() : null).add("UnprocessedBoostStatistics", this.hasUnprocessedBoostStatistics() ? this.unprocessedBoostStatistics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SamplingTargetDocuments": {
                return Optional.ofNullable(clazz.cast(this.samplingTargetDocuments()));
            }
            case "LastRuleModification": {
                return Optional.ofNullable(clazz.cast(this.lastRuleModification()));
            }
            case "UnprocessedStatistics": {
                return Optional.ofNullable(clazz.cast(this.unprocessedStatistics()));
            }
            case "UnprocessedBoostStatistics": {
                return Optional.ofNullable(clazz.cast(this.unprocessedBoostStatistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SamplingTargetDocuments", SAMPLING_TARGET_DOCUMENTS_FIELD);
        map.put("LastRuleModification", LAST_RULE_MODIFICATION_FIELD);
        map.put("UnprocessedStatistics", UNPROCESSED_STATISTICS_FIELD);
        map.put("UnprocessedBoostStatistics", UNPROCESSED_BOOST_STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSamplingTargetsResponse, T> g) {
        return obj -> g.apply((GetSamplingTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<SamplingTargetDocument> samplingTargetDocuments = DefaultSdkAutoConstructList.getInstance();
        private Instant lastRuleModification;
        private List<UnprocessedStatistics> unprocessedStatistics = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedStatistics> unprocessedBoostStatistics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSamplingTargetsResponse model) {
            super(model);
            this.samplingTargetDocuments(model.samplingTargetDocuments);
            this.lastRuleModification(model.lastRuleModification);
            this.unprocessedStatistics(model.unprocessedStatistics);
            this.unprocessedBoostStatistics(model.unprocessedBoostStatistics);
        }

        public final List<SamplingTargetDocument.Builder> getSamplingTargetDocuments() {
            List<SamplingTargetDocument.Builder> result = SamplingTargetDocumentListCopier.copyToBuilder(this.samplingTargetDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSamplingTargetDocuments(Collection<SamplingTargetDocument.BuilderImpl> samplingTargetDocuments) {
            this.samplingTargetDocuments = SamplingTargetDocumentListCopier.copyFromBuilder(samplingTargetDocuments);
        }

        @Override
        public final Builder samplingTargetDocuments(Collection<SamplingTargetDocument> samplingTargetDocuments) {
            this.samplingTargetDocuments = SamplingTargetDocumentListCopier.copy(samplingTargetDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samplingTargetDocuments(SamplingTargetDocument ... samplingTargetDocuments) {
            this.samplingTargetDocuments(Arrays.asList(samplingTargetDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samplingTargetDocuments(Consumer<SamplingTargetDocument.Builder> ... samplingTargetDocuments) {
            this.samplingTargetDocuments(Stream.of(samplingTargetDocuments).map(c -> (SamplingTargetDocument)((SamplingTargetDocument.Builder)SamplingTargetDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastRuleModification() {
            return this.lastRuleModification;
        }

        public final void setLastRuleModification(Instant lastRuleModification) {
            this.lastRuleModification = lastRuleModification;
        }

        @Override
        public final Builder lastRuleModification(Instant lastRuleModification) {
            this.lastRuleModification = lastRuleModification;
            return this;
        }

        public final List<UnprocessedStatistics.Builder> getUnprocessedStatistics() {
            List<UnprocessedStatistics.Builder> result = UnprocessedStatisticsListCopier.copyToBuilder(this.unprocessedStatistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedStatistics(Collection<UnprocessedStatistics.BuilderImpl> unprocessedStatistics) {
            this.unprocessedStatistics = UnprocessedStatisticsListCopier.copyFromBuilder(unprocessedStatistics);
        }

        @Override
        public final Builder unprocessedStatistics(Collection<UnprocessedStatistics> unprocessedStatistics) {
            this.unprocessedStatistics = UnprocessedStatisticsListCopier.copy(unprocessedStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedStatistics(UnprocessedStatistics ... unprocessedStatistics) {
            this.unprocessedStatistics(Arrays.asList(unprocessedStatistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedStatistics(Consumer<UnprocessedStatistics.Builder> ... unprocessedStatistics) {
            this.unprocessedStatistics(Stream.of(unprocessedStatistics).map(c -> (UnprocessedStatistics)((UnprocessedStatistics.Builder)UnprocessedStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedStatistics.Builder> getUnprocessedBoostStatistics() {
            List<UnprocessedStatistics.Builder> result = UnprocessedStatisticsListCopier.copyToBuilder(this.unprocessedBoostStatistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedBoostStatistics(Collection<UnprocessedStatistics.BuilderImpl> unprocessedBoostStatistics) {
            this.unprocessedBoostStatistics = UnprocessedStatisticsListCopier.copyFromBuilder(unprocessedBoostStatistics);
        }

        @Override
        public final Builder unprocessedBoostStatistics(Collection<UnprocessedStatistics> unprocessedBoostStatistics) {
            this.unprocessedBoostStatistics = UnprocessedStatisticsListCopier.copy(unprocessedBoostStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedBoostStatistics(UnprocessedStatistics ... unprocessedBoostStatistics) {
            this.unprocessedBoostStatistics(Arrays.asList(unprocessedBoostStatistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedBoostStatistics(Consumer<UnprocessedStatistics.Builder> ... unprocessedBoostStatistics) {
            this.unprocessedBoostStatistics(Stream.of(unprocessedBoostStatistics).map(c -> (UnprocessedStatistics)((UnprocessedStatistics.Builder)UnprocessedStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetSamplingTargetsResponse build() {
            return new GetSamplingTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSamplingTargetsResponse> {
        public Builder samplingTargetDocuments(Collection<SamplingTargetDocument> var1);

        public Builder samplingTargetDocuments(SamplingTargetDocument ... var1);

        public Builder samplingTargetDocuments(Consumer<SamplingTargetDocument.Builder> ... var1);

        public Builder lastRuleModification(Instant var1);

        public Builder unprocessedStatistics(Collection<UnprocessedStatistics> var1);

        public Builder unprocessedStatistics(UnprocessedStatistics ... var1);

        public Builder unprocessedStatistics(Consumer<UnprocessedStatistics.Builder> ... var1);

        public Builder unprocessedBoostStatistics(Collection<UnprocessedStatistics> var1);

        public Builder unprocessedBoostStatistics(UnprocessedStatistics ... var1);

        public Builder unprocessedBoostStatistics(Consumer<UnprocessedStatistics.Builder> ... var1);
    }
}

