/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayClient;
import software.amazon.awssdk.services.xray.internal.UserAgentUtils;
import software.amazon.awssdk.services.xray.model.GetGroupsRequest;
import software.amazon.awssdk.services.xray.model.GetGroupsResponse;
import software.amazon.awssdk.services.xray.model.GroupSummary;

public class GetGroupsIterable
implements SdkIterable<GetGroupsResponse> {
    private final XRayClient client;
    private final GetGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetGroupsIterable(XRayClient client, GetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetGroupsResponseFetcher();
    }

    public Iterator<GetGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GroupSummary> groups() {
        Function<GetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groups() != null) {
                return response.groups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetGroupsResponseFetcher
    implements SyncPageFetcher<GetGroupsResponse> {
        private GetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(GetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetGroupsResponse nextPage(GetGroupsResponse previousPage) {
            if (previousPage == null) {
                return GetGroupsIterable.this.client.getGroups(GetGroupsIterable.this.firstRequest);
            }
            return GetGroupsIterable.this.client.getGroups((GetGroupsRequest)((Object)GetGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

