/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayAsyncClient;
import software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesResponse;
import software.amazon.awssdk.services.xray.model.SamplingStatisticSummary;

public class GetSamplingStatisticSummariesPublisher
implements SdkPublisher<GetSamplingStatisticSummariesResponse> {
    private final XRayAsyncClient client;
    private final GetSamplingStatisticSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetSamplingStatisticSummariesPublisher(XRayAsyncClient client, GetSamplingStatisticSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetSamplingStatisticSummariesPublisher(XRayAsyncClient client, GetSamplingStatisticSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetSamplingStatisticSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetSamplingStatisticSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SamplingStatisticSummary> samplingStatisticSummaries() {
        Function<GetSamplingStatisticSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.samplingStatisticSummaries() != null) {
                return response.samplingStatisticSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetSamplingStatisticSummariesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetSamplingStatisticSummariesResponseFetcher
    implements AsyncPageFetcher<GetSamplingStatisticSummariesResponse> {
        private GetSamplingStatisticSummariesResponseFetcher() {
        }

        public boolean hasNextPage(GetSamplingStatisticSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetSamplingStatisticSummariesResponse> nextPage(GetSamplingStatisticSummariesResponse previousPage) {
            if (previousPage == null) {
                return GetSamplingStatisticSummariesPublisher.this.client.getSamplingStatisticSummaries(GetSamplingStatisticSummariesPublisher.this.firstRequest);
            }
            return GetSamplingStatisticSummariesPublisher.this.client.getSamplingStatisticSummaries((GetSamplingStatisticSummariesRequest)((Object)GetSamplingStatisticSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

