/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of segments and corresponding subsegments associated to a trace summary fault error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FaultRootCauseEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<FaultRootCauseEntity.Builder, FaultRootCauseEntity> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(FaultRootCauseEntity::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<RootCauseException>> EXCEPTIONS_FIELD = SdkField
            .<List<RootCauseException>> builder(MarshallingType.LIST)
            .memberName("Exceptions")
            .getter(getter(FaultRootCauseEntity::exceptions))
            .setter(setter(Builder::exceptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exceptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RootCauseException> builder(MarshallingType.SDK_POJO)
                                            .constructor(RootCauseException::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> REMOTE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Remote").getter(getter(FaultRootCauseEntity::remote)).setter(setter(Builder::remote))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Remote").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EXCEPTIONS_FIELD,
            REMOTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<RootCauseException> exceptions;

    private final Boolean remote;

    private FaultRootCauseEntity(BuilderImpl builder) {
        this.name = builder.name;
        this.exceptions = builder.exceptions;
        this.remote = builder.remote;
    }

    /**
     * <p>
     * The name of the entity.
     * </p>
     * 
     * @return The name of the entity.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Exceptions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExceptions() {
        return exceptions != null && !(exceptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types and messages of the exceptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExceptions} method.
     * </p>
     * 
     * @return The types and messages of the exceptions.
     */
    public final List<RootCauseException> exceptions() {
        return exceptions;
    }

    /**
     * <p>
     * A flag that denotes a remote subsegment.
     * </p>
     * 
     * @return A flag that denotes a remote subsegment.
     */
    public final Boolean remote() {
        return remote;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasExceptions() ? exceptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(remote());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaultRootCauseEntity)) {
            return false;
        }
        FaultRootCauseEntity other = (FaultRootCauseEntity) obj;
        return Objects.equals(name(), other.name()) && hasExceptions() == other.hasExceptions()
                && Objects.equals(exceptions(), other.exceptions()) && Objects.equals(remote(), other.remote());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FaultRootCauseEntity").add("Name", name())
                .add("Exceptions", hasExceptions() ? exceptions() : null).add("Remote", remote()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Exceptions":
            return Optional.ofNullable(clazz.cast(exceptions()));
        case "Remote":
            return Optional.ofNullable(clazz.cast(remote()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FaultRootCauseEntity, T> g) {
        return obj -> g.apply((FaultRootCauseEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FaultRootCauseEntity> {
        /**
         * <p>
         * The name of the entity.
         * </p>
         * 
         * @param name
         *        The name of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The types and messages of the exceptions.
         * </p>
         * 
         * @param exceptions
         *        The types and messages of the exceptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exceptions(Collection<RootCauseException> exceptions);

        /**
         * <p>
         * The types and messages of the exceptions.
         * </p>
         * 
         * @param exceptions
         *        The types and messages of the exceptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exceptions(RootCauseException... exceptions);

        /**
         * <p>
         * The types and messages of the exceptions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RootCauseException>.Builder} avoiding the
         * need to create one manually via {@link List<RootCauseException>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RootCauseException>.Builder#build()} is called immediately
         * and its result is passed to {@link #exceptions(List<RootCauseException>)}.
         * 
         * @param exceptions
         *        a consumer that will call methods on {@link List<RootCauseException>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exceptions(List<RootCauseException>)
         */
        Builder exceptions(Consumer<RootCauseException.Builder>... exceptions);

        /**
         * <p>
         * A flag that denotes a remote subsegment.
         * </p>
         * 
         * @param remote
         *        A flag that denotes a remote subsegment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remote(Boolean remote);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<RootCauseException> exceptions = DefaultSdkAutoConstructList.getInstance();

        private Boolean remote;

        private BuilderImpl() {
        }

        private BuilderImpl(FaultRootCauseEntity model) {
            name(model.name);
            exceptions(model.exceptions);
            remote(model.remote);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<RootCauseException.Builder> getExceptions() {
            List<RootCauseException.Builder> result = RootCauseExceptionsCopier.copyToBuilder(this.exceptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExceptions(Collection<RootCauseException.BuilderImpl> exceptions) {
            this.exceptions = RootCauseExceptionsCopier.copyFromBuilder(exceptions);
        }

        @Override
        @Transient
        public final Builder exceptions(Collection<RootCauseException> exceptions) {
            this.exceptions = RootCauseExceptionsCopier.copy(exceptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder exceptions(RootCauseException... exceptions) {
            exceptions(Arrays.asList(exceptions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder exceptions(Consumer<RootCauseException.Builder>... exceptions) {
            exceptions(Stream.of(exceptions).map(c -> RootCauseException.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getRemote() {
            return remote;
        }

        public final void setRemote(Boolean remote) {
            this.remote = remote;
        }

        @Override
        @Transient
        public final Builder remote(Boolean remote) {
            this.remote = remote;
            return this;
        }

        @Override
        public FaultRootCauseEntity build() {
            return new FaultRootCauseEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
