/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse;

public class ListIdentityProvidersIterable
implements SdkIterable<ListIdentityProvidersResponse> {
    private final WorkSpacesWebClient client;
    private final ListIdentityProvidersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIdentityProvidersIterable(WorkSpacesWebClient client, ListIdentityProvidersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIdentityProvidersResponseFetcher();
    }

    public Iterator<ListIdentityProvidersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListIdentityProvidersResponseFetcher
    implements SyncPageFetcher<ListIdentityProvidersResponse> {
        private ListIdentityProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListIdentityProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIdentityProvidersResponse nextPage(ListIdentityProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListIdentityProvidersIterable.this.client.listIdentityProviders(ListIdentityProvidersIterable.this.firstRequest);
            }
            return ListIdentityProvidersIterable.this.client.listIdentityProviders((ListIdentityProvidersRequest)((Object)ListIdentityProvidersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

