/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebAsyncClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.DataProtectionSettingsSummary;
import software.amazon.awssdk.services.workspacesweb.model.ListDataProtectionSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListDataProtectionSettingsResponse;

public class ListDataProtectionSettingsPublisher
implements SdkPublisher<ListDataProtectionSettingsResponse> {
    private final WorkSpacesWebAsyncClient client;
    private final ListDataProtectionSettingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataProtectionSettingsPublisher(WorkSpacesWebAsyncClient client, ListDataProtectionSettingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataProtectionSettingsPublisher(WorkSpacesWebAsyncClient client, ListDataProtectionSettingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataProtectionSettingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataProtectionSettingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataProtectionSettingsSummary> dataProtectionSettings() {
        Function<ListDataProtectionSettingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataProtectionSettings() != null) {
                return response.dataProtectionSettings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataProtectionSettingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataProtectionSettingsResponseFetcher
    implements AsyncPageFetcher<ListDataProtectionSettingsResponse> {
        private ListDataProtectionSettingsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataProtectionSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataProtectionSettingsResponse> nextPage(ListDataProtectionSettingsResponse previousPage) {
            if (previousPage == null) {
                return ListDataProtectionSettingsPublisher.this.client.listDataProtectionSettings(ListDataProtectionSettingsPublisher.this.firstRequest);
            }
            return ListDataProtectionSettingsPublisher.this.client.listDataProtectionSettings((ListDataProtectionSettingsRequest)((Object)ListDataProtectionSettingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

