/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.BlockedCategoriesCopier;
import software.amazon.awssdk.services.workspacesweb.model.Category;
import software.amazon.awssdk.services.workspacesweb.model.UrlPatternListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebContentFilteringPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebContentFilteringPolicy> {
    private static final SdkField<List<String>> BLOCKED_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blockedCategories").getter(WebContentFilteringPolicy.getter(WebContentFilteringPolicy::blockedCategoriesAsStrings)).setter(WebContentFilteringPolicy.setter(Builder::blockedCategoriesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedUrls").getter(WebContentFilteringPolicy.getter(WebContentFilteringPolicy::allowedUrls)).setter(WebContentFilteringPolicy.setter(Builder::allowedUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BLOCKED_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blockedUrls").getter(WebContentFilteringPolicy.getter(WebContentFilteringPolicy::blockedUrls)).setter(WebContentFilteringPolicy.setter(Builder::blockedUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKED_CATEGORIES_FIELD, ALLOWED_URLS_FIELD, BLOCKED_URLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WebContentFilteringPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> blockedCategories;
    private final List<String> allowedUrls;
    private final List<String> blockedUrls;

    private WebContentFilteringPolicy(BuilderImpl builder) {
        this.blockedCategories = builder.blockedCategories;
        this.allowedUrls = builder.allowedUrls;
        this.blockedUrls = builder.blockedUrls;
    }

    public final List<Category> blockedCategories() {
        return BlockedCategoriesCopier.copyStringToEnum(this.blockedCategories);
    }

    public final boolean hasBlockedCategories() {
        return this.blockedCategories != null && !(this.blockedCategories instanceof SdkAutoConstructList);
    }

    public final List<String> blockedCategoriesAsStrings() {
        return this.blockedCategories;
    }

    public final boolean hasAllowedUrls() {
        return this.allowedUrls != null && !(this.allowedUrls instanceof SdkAutoConstructList);
    }

    public final List<String> allowedUrls() {
        return this.allowedUrls;
    }

    public final boolean hasBlockedUrls() {
        return this.blockedUrls != null && !(this.blockedUrls instanceof SdkAutoConstructList);
    }

    public final List<String> blockedUrls() {
        return this.blockedUrls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockedCategories() ? this.blockedCategoriesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedUrls() ? this.allowedUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockedUrls() ? this.blockedUrls() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebContentFilteringPolicy)) {
            return false;
        }
        WebContentFilteringPolicy other = (WebContentFilteringPolicy)obj;
        return this.hasBlockedCategories() == other.hasBlockedCategories() && Objects.equals(this.blockedCategoriesAsStrings(), other.blockedCategoriesAsStrings()) && this.hasAllowedUrls() == other.hasAllowedUrls() && Objects.equals(this.allowedUrls(), other.allowedUrls()) && this.hasBlockedUrls() == other.hasBlockedUrls() && Objects.equals(this.blockedUrls(), other.blockedUrls());
    }

    public final String toString() {
        return ToString.builder((String)"WebContentFilteringPolicy").add("BlockedCategories", this.hasBlockedCategories() ? this.blockedCategoriesAsStrings() : null).add("AllowedUrls", (Object)(this.allowedUrls() == null ? null : "*** Sensitive Data Redacted ***")).add("BlockedUrls", (Object)(this.blockedUrls() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blockedCategories": {
                return Optional.ofNullable(clazz.cast(this.blockedCategoriesAsStrings()));
            }
            case "allowedUrls": {
                return Optional.ofNullable(clazz.cast(this.allowedUrls()));
            }
            case "blockedUrls": {
                return Optional.ofNullable(clazz.cast(this.blockedUrls()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("blockedCategories", BLOCKED_CATEGORIES_FIELD);
        map.put("allowedUrls", ALLOWED_URLS_FIELD);
        map.put("blockedUrls", BLOCKED_URLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebContentFilteringPolicy, T> g) {
        return obj -> g.apply((WebContentFilteringPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> blockedCategories = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedUrls = DefaultSdkAutoConstructList.getInstance();
        private List<String> blockedUrls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WebContentFilteringPolicy model) {
            this.blockedCategoriesWithStrings(model.blockedCategories);
            this.allowedUrls(model.allowedUrls);
            this.blockedUrls(model.blockedUrls);
        }

        public final Collection<String> getBlockedCategories() {
            if (this.blockedCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.blockedCategories;
        }

        public final void setBlockedCategories(Collection<String> blockedCategories) {
            this.blockedCategories = BlockedCategoriesCopier.copy(blockedCategories);
        }

        @Override
        public final Builder blockedCategoriesWithStrings(Collection<String> blockedCategories) {
            this.blockedCategories = BlockedCategoriesCopier.copy(blockedCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedCategoriesWithStrings(String ... blockedCategories) {
            this.blockedCategoriesWithStrings(Arrays.asList(blockedCategories));
            return this;
        }

        @Override
        public final Builder blockedCategories(Collection<Category> blockedCategories) {
            this.blockedCategories = BlockedCategoriesCopier.copyEnumToString(blockedCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedCategories(Category ... blockedCategories) {
            this.blockedCategories(Arrays.asList(blockedCategories));
            return this;
        }

        public final Collection<String> getAllowedUrls() {
            if (this.allowedUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedUrls;
        }

        public final void setAllowedUrls(Collection<String> allowedUrls) {
            this.allowedUrls = UrlPatternListCopier.copy(allowedUrls);
        }

        @Override
        public final Builder allowedUrls(Collection<String> allowedUrls) {
            this.allowedUrls = UrlPatternListCopier.copy(allowedUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedUrls(String ... allowedUrls) {
            this.allowedUrls(Arrays.asList(allowedUrls));
            return this;
        }

        public final Collection<String> getBlockedUrls() {
            if (this.blockedUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.blockedUrls;
        }

        public final void setBlockedUrls(Collection<String> blockedUrls) {
            this.blockedUrls = UrlPatternListCopier.copy(blockedUrls);
        }

        @Override
        public final Builder blockedUrls(Collection<String> blockedUrls) {
            this.blockedUrls = UrlPatternListCopier.copy(blockedUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedUrls(String ... blockedUrls) {
            this.blockedUrls(Arrays.asList(blockedUrls));
            return this;
        }

        public WebContentFilteringPolicy build() {
            return new WebContentFilteringPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebContentFilteringPolicy> {
        public Builder blockedCategoriesWithStrings(Collection<String> var1);

        public Builder blockedCategoriesWithStrings(String ... var1);

        public Builder blockedCategories(Collection<Category> var1);

        public Builder blockedCategories(Category ... var1);

        public Builder allowedUrls(Collection<String> var1);

        public Builder allowedUrls(String ... var1);

        public Builder blockedUrls(Collection<String> var1);

        public Builder blockedUrls(String ... var1);
    }
}

