/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EnabledType {
    DISABLED("Disabled"),
    ENABLED("Enabled"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EnabledType> VALUE_MAP;
    private final String value;

    private EnabledType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EnabledType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EnabledType> knownValues() {
        EnumSet<EnabledType> knownValues = EnumSet.allOf(EnabledType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EnabledType.class, EnabledType::toString);
    }
}

