/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebAsyncClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse;

public class ListTrustStoreCertificatesPublisher
implements SdkPublisher<ListTrustStoreCertificatesResponse> {
    private final WorkSpacesWebAsyncClient client;
    private final ListTrustStoreCertificatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrustStoreCertificatesPublisher(WorkSpacesWebAsyncClient client, ListTrustStoreCertificatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrustStoreCertificatesPublisher(WorkSpacesWebAsyncClient client, ListTrustStoreCertificatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrustStoreCertificatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrustStoreCertificatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTrustStoreCertificatesResponseFetcher
    implements AsyncPageFetcher<ListTrustStoreCertificatesResponse> {
        private ListTrustStoreCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListTrustStoreCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrustStoreCertificatesResponse> nextPage(ListTrustStoreCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListTrustStoreCertificatesPublisher.this.client.listTrustStoreCertificates(ListTrustStoreCertificatesPublisher.this.firstRequest);
            }
            return ListTrustStoreCertificatesPublisher.this.client.listTrustStoreCertificates((ListTrustStoreCertificatesRequest)((Object)ListTrustStoreCertificatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

