/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesinstances.WorkspacesInstancesClient;
import software.amazon.awssdk.services.workspacesinstances.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest;
import software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesResponse;
import software.amazon.awssdk.services.workspacesinstances.model.WorkspaceInstance;

public class ListWorkspaceInstancesIterable
implements SdkIterable<ListWorkspaceInstancesResponse> {
    private final WorkspacesInstancesClient client;
    private final ListWorkspaceInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkspaceInstancesIterable(WorkspacesInstancesClient client, ListWorkspaceInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkspaceInstancesResponseFetcher();
    }

    public Iterator<ListWorkspaceInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkspaceInstance> workspaceInstances() {
        Function<ListWorkspaceInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.workspaceInstances() != null) {
                return response.workspaceInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkspaceInstancesResponseFetcher
    implements SyncPageFetcher<ListWorkspaceInstancesResponse> {
        private ListWorkspaceInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkspaceInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkspaceInstancesResponse nextPage(ListWorkspaceInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkspaceInstancesIterable.this.client.listWorkspaceInstances(ListWorkspaceInstancesIterable.this.firstRequest);
            }
            return ListWorkspaceInstancesIterable.this.client.listWorkspaceInstances((ListWorkspaceInstancesRequest)((Object)ListWorkspaceInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

