/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesinstances.model.HttpEndpointEnum;
import software.amazon.awssdk.services.workspacesinstances.model.HttpProtocolIpv6Enum;
import software.amazon.awssdk.services.workspacesinstances.model.HttpTokensEnum;
import software.amazon.awssdk.services.workspacesinstances.model.InstanceMetadataTagsEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceMetadataOptionsRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceMetadataOptionsRequest> {
    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpEndpoint").getter(InstanceMetadataOptionsRequest.getter(InstanceMetadataOptionsRequest::httpEndpointAsString)).setter(InstanceMetadataOptionsRequest.setter(Builder::httpEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpoint").build()}).build();
    private static final SdkField<String> HTTP_PROTOCOL_IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpProtocolIpv6").getter(InstanceMetadataOptionsRequest.getter(InstanceMetadataOptionsRequest::httpProtocolIpv6AsString)).setter(InstanceMetadataOptionsRequest.setter(Builder::httpProtocolIpv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpProtocolIpv6").build()}).build();
    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HttpPutResponseHopLimit").getter(InstanceMetadataOptionsRequest.getter(InstanceMetadataOptionsRequest::httpPutResponseHopLimit)).setter(InstanceMetadataOptionsRequest.setter(Builder::httpPutResponseHopLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPutResponseHopLimit").build()}).build();
    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpTokens").getter(InstanceMetadataOptionsRequest.getter(InstanceMetadataOptionsRequest::httpTokensAsString)).setter(InstanceMetadataOptionsRequest.setter(Builder::httpTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpTokens").build()}).build();
    private static final SdkField<String> INSTANCE_METADATA_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceMetadataTags").getter(InstanceMetadataOptionsRequest.getter(InstanceMetadataOptionsRequest::instanceMetadataTagsAsString)).setter(InstanceMetadataOptionsRequest.setter(Builder::instanceMetadataTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMetadataTags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_ENDPOINT_FIELD, HTTP_PROTOCOL_IPV6_FIELD, HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD, HTTP_TOKENS_FIELD, INSTANCE_METADATA_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceMetadataOptionsRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String httpEndpoint;
    private final String httpProtocolIpv6;
    private final Integer httpPutResponseHopLimit;
    private final String httpTokens;
    private final String instanceMetadataTags;

    private InstanceMetadataOptionsRequest(BuilderImpl builder) {
        this.httpEndpoint = builder.httpEndpoint;
        this.httpProtocolIpv6 = builder.httpProtocolIpv6;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
        this.httpTokens = builder.httpTokens;
        this.instanceMetadataTags = builder.instanceMetadataTags;
    }

    public final HttpEndpointEnum httpEndpoint() {
        return HttpEndpointEnum.fromValue(this.httpEndpoint);
    }

    public final String httpEndpointAsString() {
        return this.httpEndpoint;
    }

    public final HttpProtocolIpv6Enum httpProtocolIpv6() {
        return HttpProtocolIpv6Enum.fromValue(this.httpProtocolIpv6);
    }

    public final String httpProtocolIpv6AsString() {
        return this.httpProtocolIpv6;
    }

    public final Integer httpPutResponseHopLimit() {
        return this.httpPutResponseHopLimit;
    }

    public final HttpTokensEnum httpTokens() {
        return HttpTokensEnum.fromValue(this.httpTokens);
    }

    public final String httpTokensAsString() {
        return this.httpTokens;
    }

    public final InstanceMetadataTagsEnum instanceMetadataTags() {
        return InstanceMetadataTagsEnum.fromValue(this.instanceMetadataTags);
    }

    public final String instanceMetadataTagsAsString() {
        return this.instanceMetadataTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpProtocolIpv6AsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpPutResponseHopLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpTokensAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMetadataTagsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMetadataOptionsRequest)) {
            return false;
        }
        InstanceMetadataOptionsRequest other = (InstanceMetadataOptionsRequest)obj;
        return Objects.equals(this.httpEndpointAsString(), other.httpEndpointAsString()) && Objects.equals(this.httpProtocolIpv6AsString(), other.httpProtocolIpv6AsString()) && Objects.equals(this.httpPutResponseHopLimit(), other.httpPutResponseHopLimit()) && Objects.equals(this.httpTokensAsString(), other.httpTokensAsString()) && Objects.equals(this.instanceMetadataTagsAsString(), other.instanceMetadataTagsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceMetadataOptionsRequest").add("HttpEndpoint", (Object)this.httpEndpointAsString()).add("HttpProtocolIpv6", (Object)this.httpProtocolIpv6AsString()).add("HttpPutResponseHopLimit", (Object)this.httpPutResponseHopLimit()).add("HttpTokens", (Object)this.httpTokensAsString()).add("InstanceMetadataTags", (Object)this.instanceMetadataTagsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HttpEndpoint": {
                return Optional.ofNullable(clazz.cast(this.httpEndpointAsString()));
            }
            case "HttpProtocolIpv6": {
                return Optional.ofNullable(clazz.cast(this.httpProtocolIpv6AsString()));
            }
            case "HttpPutResponseHopLimit": {
                return Optional.ofNullable(clazz.cast(this.httpPutResponseHopLimit()));
            }
            case "HttpTokens": {
                return Optional.ofNullable(clazz.cast(this.httpTokensAsString()));
            }
            case "InstanceMetadataTags": {
                return Optional.ofNullable(clazz.cast(this.instanceMetadataTagsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HttpEndpoint", HTTP_ENDPOINT_FIELD);
        map.put("HttpProtocolIpv6", HTTP_PROTOCOL_IPV6_FIELD);
        map.put("HttpPutResponseHopLimit", HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD);
        map.put("HttpTokens", HTTP_TOKENS_FIELD);
        map.put("InstanceMetadataTags", INSTANCE_METADATA_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceMetadataOptionsRequest, T> g) {
        return obj -> g.apply((InstanceMetadataOptionsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String httpEndpoint;
        private String httpProtocolIpv6;
        private Integer httpPutResponseHopLimit;
        private String httpTokens;
        private String instanceMetadataTags;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMetadataOptionsRequest model) {
            this.httpEndpoint(model.httpEndpoint);
            this.httpProtocolIpv6(model.httpProtocolIpv6);
            this.httpPutResponseHopLimit(model.httpPutResponseHopLimit);
            this.httpTokens(model.httpTokens);
            this.instanceMetadataTags(model.instanceMetadataTags);
        }

        public final String getHttpEndpoint() {
            return this.httpEndpoint;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        @Override
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        @Override
        public final Builder httpEndpoint(HttpEndpointEnum httpEndpoint) {
            this.httpEndpoint(httpEndpoint == null ? null : httpEndpoint.toString());
            return this;
        }

        public final String getHttpProtocolIpv6() {
            return this.httpProtocolIpv6;
        }

        public final void setHttpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
        }

        @Override
        public final Builder httpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
            return this;
        }

        @Override
        public final Builder httpProtocolIpv6(HttpProtocolIpv6Enum httpProtocolIpv6) {
            this.httpProtocolIpv6(httpProtocolIpv6 == null ? null : httpProtocolIpv6.toString());
            return this;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return this.httpPutResponseHopLimit;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        @Override
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        public final String getHttpTokens() {
            return this.httpTokens;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        @Override
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        @Override
        public final Builder httpTokens(HttpTokensEnum httpTokens) {
            this.httpTokens(httpTokens == null ? null : httpTokens.toString());
            return this;
        }

        public final String getInstanceMetadataTags() {
            return this.instanceMetadataTags;
        }

        public final void setInstanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
        }

        @Override
        public final Builder instanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
            return this;
        }

        @Override
        public final Builder instanceMetadataTags(InstanceMetadataTagsEnum instanceMetadataTags) {
            this.instanceMetadataTags(instanceMetadataTags == null ? null : instanceMetadataTags.toString());
            return this;
        }

        public InstanceMetadataOptionsRequest build() {
            return new InstanceMetadataOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceMetadataOptionsRequest> {
        public Builder httpEndpoint(String var1);

        public Builder httpEndpoint(HttpEndpointEnum var1);

        public Builder httpProtocolIpv6(String var1);

        public Builder httpProtocolIpv6(HttpProtocolIpv6Enum var1);

        public Builder httpPutResponseHopLimit(Integer var1);

        public Builder httpTokens(String var1);

        public Builder httpTokens(HttpTokensEnum var1);

        public Builder instanceMetadataTags(String var1);

        public Builder instanceMetadataTags(InstanceMetadataTagsEnum var1);
    }
}

