/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.AccessEndpointType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessEndpoint> {
    private static final SdkField<String> ACCESS_ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessEndpointType").getter(AccessEndpoint.getter(AccessEndpoint::accessEndpointTypeAsString)).setter(AccessEndpoint.setter(Builder::accessEndpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpointType").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(AccessEndpoint.getter(AccessEndpoint::vpcEndpointId)).setter(AccessEndpoint.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_ENDPOINT_TYPE_FIELD, VPC_ENDPOINT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccessEndpoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accessEndpointType;
    private final String vpcEndpointId;

    private AccessEndpoint(BuilderImpl builder) {
        this.accessEndpointType = builder.accessEndpointType;
        this.vpcEndpointId = builder.vpcEndpointId;
    }

    public final AccessEndpointType accessEndpointType() {
        return AccessEndpointType.fromValue(this.accessEndpointType);
    }

    public final String accessEndpointTypeAsString() {
        return this.accessEndpointType;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessEndpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessEndpoint)) {
            return false;
        }
        AccessEndpoint other = (AccessEndpoint)obj;
        return Objects.equals(this.accessEndpointTypeAsString(), other.accessEndpointTypeAsString()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId());
    }

    public final String toString() {
        return ToString.builder((String)"AccessEndpoint").add("AccessEndpointType", (Object)this.accessEndpointTypeAsString()).add("VpcEndpointId", (Object)this.vpcEndpointId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessEndpointType": {
                return Optional.ofNullable(clazz.cast(this.accessEndpointTypeAsString()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AccessEndpointType", ACCESS_ENDPOINT_TYPE_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessEndpoint, T> g) {
        return obj -> g.apply((AccessEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessEndpointType;
        private String vpcEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessEndpoint model) {
            this.accessEndpointType(model.accessEndpointType);
            this.vpcEndpointId(model.vpcEndpointId);
        }

        public final String getAccessEndpointType() {
            return this.accessEndpointType;
        }

        public final void setAccessEndpointType(String accessEndpointType) {
            this.accessEndpointType = accessEndpointType;
        }

        @Override
        public final Builder accessEndpointType(String accessEndpointType) {
            this.accessEndpointType = accessEndpointType;
            return this;
        }

        @Override
        public final Builder accessEndpointType(AccessEndpointType accessEndpointType) {
            this.accessEndpointType(accessEndpointType == null ? null : accessEndpointType.toString());
            return this;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public AccessEndpoint build() {
            return new AccessEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessEndpoint> {
        public Builder accessEndpointType(String var1);

        public Builder accessEndpointType(AccessEndpointType var1);

        public Builder vpcEndpointId(String var1);
    }
}

