/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.RebuildRequest;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspaceRequestsCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RebuildWorkspacesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, RebuildWorkspacesRequest> {
    private static final SdkField<List<RebuildRequest>> REBUILD_WORKSPACE_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RebuildWorkspaceRequests").getter(RebuildWorkspacesRequest.getter(RebuildWorkspacesRequest::rebuildWorkspaceRequests)).setter(RebuildWorkspacesRequest.setter(Builder::rebuildWorkspaceRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RebuildWorkspaceRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RebuildRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REBUILD_WORKSPACE_REQUESTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RebuildWorkspacesRequest.memberNameToFieldInitializer();
    private final List<RebuildRequest> rebuildWorkspaceRequests;

    private RebuildWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.rebuildWorkspaceRequests = builder.rebuildWorkspaceRequests;
    }

    public final boolean hasRebuildWorkspaceRequests() {
        return this.rebuildWorkspaceRequests != null && !(this.rebuildWorkspaceRequests instanceof SdkAutoConstructList);
    }

    public final List<RebuildRequest> rebuildWorkspaceRequests() {
        return this.rebuildWorkspaceRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRebuildWorkspaceRequests() ? this.rebuildWorkspaceRequests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebuildWorkspacesRequest)) {
            return false;
        }
        RebuildWorkspacesRequest other = (RebuildWorkspacesRequest)((Object)obj);
        return this.hasRebuildWorkspaceRequests() == other.hasRebuildWorkspaceRequests() && Objects.equals(this.rebuildWorkspaceRequests(), other.rebuildWorkspaceRequests());
    }

    public final String toString() {
        return ToString.builder((String)"RebuildWorkspacesRequest").add("RebuildWorkspaceRequests", this.hasRebuildWorkspaceRequests() ? this.rebuildWorkspaceRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RebuildWorkspaceRequests": {
                return Optional.ofNullable(clazz.cast(this.rebuildWorkspaceRequests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<RebuildRequest>>> map = new HashMap<String, SdkField<List<RebuildRequest>>>();
        map.put("RebuildWorkspaceRequests", REBUILD_WORKSPACE_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RebuildWorkspacesRequest, T> g) {
        return obj -> g.apply((RebuildWorkspacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<RebuildRequest> rebuildWorkspaceRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RebuildWorkspacesRequest model) {
            super(model);
            this.rebuildWorkspaceRequests(model.rebuildWorkspaceRequests);
        }

        public final List<RebuildRequest.Builder> getRebuildWorkspaceRequests() {
            List<RebuildRequest.Builder> result = RebuildWorkspaceRequestsCopier.copyToBuilder(this.rebuildWorkspaceRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRebuildWorkspaceRequests(Collection<RebuildRequest.BuilderImpl> rebuildWorkspaceRequests) {
            this.rebuildWorkspaceRequests = RebuildWorkspaceRequestsCopier.copyFromBuilder(rebuildWorkspaceRequests);
        }

        @Override
        public final Builder rebuildWorkspaceRequests(Collection<RebuildRequest> rebuildWorkspaceRequests) {
            this.rebuildWorkspaceRequests = RebuildWorkspaceRequestsCopier.copy(rebuildWorkspaceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rebuildWorkspaceRequests(RebuildRequest ... rebuildWorkspaceRequests) {
            this.rebuildWorkspaceRequests(Arrays.asList(rebuildWorkspaceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rebuildWorkspaceRequests(Consumer<RebuildRequest.Builder> ... rebuildWorkspaceRequests) {
            this.rebuildWorkspaceRequests(Stream.of(rebuildWorkspaceRequests).map(c -> (RebuildRequest)((RebuildRequest.Builder)RebuildRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RebuildWorkspacesRequest build() {
            return new RebuildWorkspacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RebuildWorkspacesRequest> {
        public Builder rebuildWorkspaceRequests(Collection<RebuildRequest> var1);

        public Builder rebuildWorkspaceRequests(RebuildRequest ... var1);

        public Builder rebuildWorkspaceRequests(Consumer<RebuildRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

