/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SamlStatusEnum {
    DISABLED("DISABLED"),
    ENABLED("ENABLED"),
    ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK("ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SamlStatusEnum> VALUE_MAP;
    private final String value;

    private SamlStatusEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SamlStatusEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SamlStatusEnum> knownValues() {
        EnumSet<SamlStatusEnum> knownValues = EnumSet.allOf(SamlStatusEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SamlStatusEnum.class, SamlStatusEnum::toString);
    }
}

