/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Compute {
    VALUE("VALUE"),
    STANDARD("STANDARD"),
    PERFORMANCE("PERFORMANCE"),
    POWER("POWER"),
    GRAPHICS("GRAPHICS"),
    POWERPRO("POWERPRO"),
    GENERALPURPOSE_4_XLARGE("GENERALPURPOSE_4XLARGE"),
    GENERALPURPOSE_8_XLARGE("GENERALPURPOSE_8XLARGE"),
    GRAPHICSPRO("GRAPHICSPRO"),
    GRAPHICS_G4_DN("GRAPHICS_G4DN"),
    GRAPHICSPRO_G4_DN("GRAPHICSPRO_G4DN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Compute> VALUE_MAP;
    private final String value;

    private Compute(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Compute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Compute> knownValues() {
        EnumSet<Compute> knownValues = EnumSet.allOf(Compute.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Compute.class, Compute::toString);
    }
}

