/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActiveDirectoryConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActiveDirectoryConfig> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(ActiveDirectoryConfig.getter(ActiveDirectoryConfig::domainName)).setter(ActiveDirectoryConfig.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> SERVICE_ACCOUNT_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccountSecretArn").getter(ActiveDirectoryConfig.getter(ActiveDirectoryConfig::serviceAccountSecretArn)).setter(ActiveDirectoryConfig.setter(Builder::serviceAccountSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccountSecretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, SERVICE_ACCOUNT_SECRET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ActiveDirectoryConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String serviceAccountSecretArn;

    private ActiveDirectoryConfig(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.serviceAccountSecretArn = builder.serviceAccountSecretArn;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String serviceAccountSecretArn() {
        return this.serviceAccountSecretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountSecretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveDirectoryConfig)) {
            return false;
        }
        ActiveDirectoryConfig other = (ActiveDirectoryConfig)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.serviceAccountSecretArn(), other.serviceAccountSecretArn());
    }

    public final String toString() {
        return ToString.builder((String)"ActiveDirectoryConfig").add("DomainName", (Object)this.domainName()).add("ServiceAccountSecretArn", (Object)this.serviceAccountSecretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ServiceAccountSecretArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountSecretArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ServiceAccountSecretArn", SERVICE_ACCOUNT_SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActiveDirectoryConfig, T> g) {
        return obj -> g.apply((ActiveDirectoryConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String serviceAccountSecretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveDirectoryConfig model) {
            this.domainName(model.domainName);
            this.serviceAccountSecretArn(model.serviceAccountSecretArn);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getServiceAccountSecretArn() {
            return this.serviceAccountSecretArn;
        }

        public final void setServiceAccountSecretArn(String serviceAccountSecretArn) {
            this.serviceAccountSecretArn = serviceAccountSecretArn;
        }

        @Override
        public final Builder serviceAccountSecretArn(String serviceAccountSecretArn) {
            this.serviceAccountSecretArn = serviceAccountSecretArn;
            return this;
        }

        public ActiveDirectoryConfig build() {
            return new ActiveDirectoryConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActiveDirectoryConfig> {
        public Builder domainName(String var1);

        public Builder serviceAccountSecretArn(String var1);
    }
}

