/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkSpaceApplicationState {
    PENDING("PENDING"),
    ERROR("ERROR"),
    AVAILABLE("AVAILABLE"),
    UNINSTALL_ONLY("UNINSTALL_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkSpaceApplicationState> VALUE_MAP;
    private final String value;

    private WorkSpaceApplicationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkSpaceApplicationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkSpaceApplicationState> knownValues() {
        EnumSet<WorkSpaceApplicationState> knownValues = EnumSet.allOf(WorkSpaceApplicationState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkSpaceApplicationState.class, WorkSpaceApplicationState::toString);
    }
}

