/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.ApplicationSettingsStatusEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationSettingsRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationSettingsRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ApplicationSettingsRequest.getter(ApplicationSettingsRequest::statusAsString)).setter(ApplicationSettingsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SETTINGS_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SettingsGroup").getter(ApplicationSettingsRequest.getter(ApplicationSettingsRequest::settingsGroup)).setter(ApplicationSettingsRequest.setter(Builder::settingsGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingsGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, SETTINGS_GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationSettingsRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String settingsGroup;

    private ApplicationSettingsRequest(BuilderImpl builder) {
        this.status = builder.status;
        this.settingsGroup = builder.settingsGroup;
    }

    public final ApplicationSettingsStatusEnum status() {
        return ApplicationSettingsStatusEnum.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String settingsGroup() {
        return this.settingsGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.settingsGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSettingsRequest)) {
            return false;
        }
        ApplicationSettingsRequest other = (ApplicationSettingsRequest)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.settingsGroup(), other.settingsGroup());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationSettingsRequest").add("Status", (Object)this.statusAsString()).add("SettingsGroup", (Object)this.settingsGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SettingsGroup": {
                return Optional.ofNullable(clazz.cast(this.settingsGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Status", STATUS_FIELD);
        map.put("SettingsGroup", SETTINGS_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSettingsRequest, T> g) {
        return obj -> g.apply((ApplicationSettingsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String settingsGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSettingsRequest model) {
            this.status(model.status);
            this.settingsGroup(model.settingsGroup);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationSettingsStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSettingsGroup() {
            return this.settingsGroup;
        }

        public final void setSettingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
        }

        @Override
        @Transient
        public final Builder settingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
            return this;
        }

        public ApplicationSettingsRequest build() {
            return new ApplicationSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationSettingsRequest> {
        public Builder status(String var1);

        public Builder status(ApplicationSettingsStatusEnum var1);

        public Builder settingsGroup(String var1);
    }
}

