/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModificationStateEnum {
    UPDATE_INITIATED("UPDATE_INITIATED"),
    UPDATE_IN_PROGRESS("UPDATE_IN_PROGRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModificationStateEnum> VALUE_MAP;
    private final String value;

    private ModificationStateEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModificationStateEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModificationStateEnum> knownValues() {
        EnumSet<ModificationStateEnum> knownValues = EnumSet.allOf(ModificationStateEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModificationStateEnum.class, ModificationStateEnum::toString);
    }
}

