/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.BundleListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.services.workspaces.model.WorkspaceBundle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspaceBundlesResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeWorkspaceBundlesResponse> {
    private static final SdkField<List<WorkspaceBundle>> BUNDLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Bundles").getter(DescribeWorkspaceBundlesResponse.getter(DescribeWorkspaceBundlesResponse::bundles)).setter(DescribeWorkspaceBundlesResponse.setter(Builder::bundles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bundles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspaceBundle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeWorkspaceBundlesResponse.getter(DescribeWorkspaceBundlesResponse::nextToken)).setter(DescribeWorkspaceBundlesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeWorkspaceBundlesResponse.memberNameToFieldInitializer();
    private final List<WorkspaceBundle> bundles;
    private final String nextToken;

    private DescribeWorkspaceBundlesResponse(BuilderImpl builder) {
        super(builder);
        this.bundles = builder.bundles;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBundles() {
        return this.bundles != null && !(this.bundles instanceof SdkAutoConstructList);
    }

    public final List<WorkspaceBundle> bundles() {
        return this.bundles;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBundles() ? this.bundles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceBundlesResponse)) {
            return false;
        }
        DescribeWorkspaceBundlesResponse other = (DescribeWorkspaceBundlesResponse)((Object)obj);
        return this.hasBundles() == other.hasBundles() && Objects.equals(this.bundles(), other.bundles()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspaceBundlesResponse").add("Bundles", this.hasBundles() ? this.bundles() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bundles": {
                return Optional.ofNullable(clazz.cast(this.bundles()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Bundles", BUNDLES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceBundlesResponse, T> g) {
        return obj -> g.apply((DescribeWorkspaceBundlesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<WorkspaceBundle> bundles = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceBundlesResponse model) {
            super(model);
            this.bundles(model.bundles);
            this.nextToken(model.nextToken);
        }

        public final List<WorkspaceBundle.Builder> getBundles() {
            List<WorkspaceBundle.Builder> result = BundleListCopier.copyToBuilder(this.bundles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBundles(Collection<WorkspaceBundle.BuilderImpl> bundles) {
            this.bundles = BundleListCopier.copyFromBuilder(bundles);
        }

        @Override
        public final Builder bundles(Collection<WorkspaceBundle> bundles) {
            this.bundles = BundleListCopier.copy(bundles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(WorkspaceBundle ... bundles) {
            this.bundles(Arrays.asList(bundles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(Consumer<WorkspaceBundle.Builder> ... bundles) {
            this.bundles(Stream.of(bundles).map(c -> (WorkspaceBundle)((WorkspaceBundle.Builder)WorkspaceBundle.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeWorkspaceBundlesResponse build() {
            return new DescribeWorkspaceBundlesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspaceBundlesResponse> {
        public Builder bundles(Collection<WorkspaceBundle> var1);

        public Builder bundles(WorkspaceBundle ... var1);

        public Builder bundles(Consumer<WorkspaceBundle.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

