/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.DedicatedTenancyAccountType;
import software.amazon.awssdk.services.workspaces.model.DedicatedTenancySupportResultEnum;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeAccountResponse> {
    private static final SdkField<String> DEDICATED_TENANCY_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DedicatedTenancySupport").getter(DescribeAccountResponse.getter(DescribeAccountResponse::dedicatedTenancySupportAsString)).setter(DescribeAccountResponse.setter(Builder::dedicatedTenancySupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedTenancySupport").build()}).build();
    private static final SdkField<String> DEDICATED_TENANCY_MANAGEMENT_CIDR_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DedicatedTenancyManagementCidrRange").getter(DescribeAccountResponse.getter(DescribeAccountResponse::dedicatedTenancyManagementCidrRange)).setter(DescribeAccountResponse.setter(Builder::dedicatedTenancyManagementCidrRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedTenancyManagementCidrRange").build()}).build();
    private static final SdkField<String> DEDICATED_TENANCY_ACCOUNT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DedicatedTenancyAccountType").getter(DescribeAccountResponse.getter(DescribeAccountResponse::dedicatedTenancyAccountTypeAsString)).setter(DescribeAccountResponse.setter(Builder::dedicatedTenancyAccountType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedTenancyAccountType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEDICATED_TENANCY_SUPPORT_FIELD, DEDICATED_TENANCY_MANAGEMENT_CIDR_RANGE_FIELD, DEDICATED_TENANCY_ACCOUNT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAccountResponse.memberNameToFieldInitializer();
    private final String dedicatedTenancySupport;
    private final String dedicatedTenancyManagementCidrRange;
    private final String dedicatedTenancyAccountType;

    private DescribeAccountResponse(BuilderImpl builder) {
        super(builder);
        this.dedicatedTenancySupport = builder.dedicatedTenancySupport;
        this.dedicatedTenancyManagementCidrRange = builder.dedicatedTenancyManagementCidrRange;
        this.dedicatedTenancyAccountType = builder.dedicatedTenancyAccountType;
    }

    public final DedicatedTenancySupportResultEnum dedicatedTenancySupport() {
        return DedicatedTenancySupportResultEnum.fromValue(this.dedicatedTenancySupport);
    }

    public final String dedicatedTenancySupportAsString() {
        return this.dedicatedTenancySupport;
    }

    public final String dedicatedTenancyManagementCidrRange() {
        return this.dedicatedTenancyManagementCidrRange;
    }

    public final DedicatedTenancyAccountType dedicatedTenancyAccountType() {
        return DedicatedTenancyAccountType.fromValue(this.dedicatedTenancyAccountType);
    }

    public final String dedicatedTenancyAccountTypeAsString() {
        return this.dedicatedTenancyAccountType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedTenancySupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedTenancyManagementCidrRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedTenancyAccountTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountResponse)) {
            return false;
        }
        DescribeAccountResponse other = (DescribeAccountResponse)((Object)obj);
        return Objects.equals(this.dedicatedTenancySupportAsString(), other.dedicatedTenancySupportAsString()) && Objects.equals(this.dedicatedTenancyManagementCidrRange(), other.dedicatedTenancyManagementCidrRange()) && Objects.equals(this.dedicatedTenancyAccountTypeAsString(), other.dedicatedTenancyAccountTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAccountResponse").add("DedicatedTenancySupport", (Object)this.dedicatedTenancySupportAsString()).add("DedicatedTenancyManagementCidrRange", (Object)this.dedicatedTenancyManagementCidrRange()).add("DedicatedTenancyAccountType", (Object)this.dedicatedTenancyAccountTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DedicatedTenancySupport": {
                return Optional.ofNullable(clazz.cast(this.dedicatedTenancySupportAsString()));
            }
            case "DedicatedTenancyManagementCidrRange": {
                return Optional.ofNullable(clazz.cast(this.dedicatedTenancyManagementCidrRange()));
            }
            case "DedicatedTenancyAccountType": {
                return Optional.ofNullable(clazz.cast(this.dedicatedTenancyAccountTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DedicatedTenancySupport", DEDICATED_TENANCY_SUPPORT_FIELD);
        map.put("DedicatedTenancyManagementCidrRange", DEDICATED_TENANCY_MANAGEMENT_CIDR_RANGE_FIELD);
        map.put("DedicatedTenancyAccountType", DEDICATED_TENANCY_ACCOUNT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountResponse, T> g) {
        return obj -> g.apply((DescribeAccountResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private String dedicatedTenancySupport;
        private String dedicatedTenancyManagementCidrRange;
        private String dedicatedTenancyAccountType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountResponse model) {
            super(model);
            this.dedicatedTenancySupport(model.dedicatedTenancySupport);
            this.dedicatedTenancyManagementCidrRange(model.dedicatedTenancyManagementCidrRange);
            this.dedicatedTenancyAccountType(model.dedicatedTenancyAccountType);
        }

        public final String getDedicatedTenancySupport() {
            return this.dedicatedTenancySupport;
        }

        public final void setDedicatedTenancySupport(String dedicatedTenancySupport) {
            this.dedicatedTenancySupport = dedicatedTenancySupport;
        }

        @Override
        public final Builder dedicatedTenancySupport(String dedicatedTenancySupport) {
            this.dedicatedTenancySupport = dedicatedTenancySupport;
            return this;
        }

        @Override
        public final Builder dedicatedTenancySupport(DedicatedTenancySupportResultEnum dedicatedTenancySupport) {
            this.dedicatedTenancySupport(dedicatedTenancySupport == null ? null : dedicatedTenancySupport.toString());
            return this;
        }

        public final String getDedicatedTenancyManagementCidrRange() {
            return this.dedicatedTenancyManagementCidrRange;
        }

        public final void setDedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange) {
            this.dedicatedTenancyManagementCidrRange = dedicatedTenancyManagementCidrRange;
        }

        @Override
        public final Builder dedicatedTenancyManagementCidrRange(String dedicatedTenancyManagementCidrRange) {
            this.dedicatedTenancyManagementCidrRange = dedicatedTenancyManagementCidrRange;
            return this;
        }

        public final String getDedicatedTenancyAccountType() {
            return this.dedicatedTenancyAccountType;
        }

        public final void setDedicatedTenancyAccountType(String dedicatedTenancyAccountType) {
            this.dedicatedTenancyAccountType = dedicatedTenancyAccountType;
        }

        @Override
        public final Builder dedicatedTenancyAccountType(String dedicatedTenancyAccountType) {
            this.dedicatedTenancyAccountType = dedicatedTenancyAccountType;
            return this;
        }

        @Override
        public final Builder dedicatedTenancyAccountType(DedicatedTenancyAccountType dedicatedTenancyAccountType) {
            this.dedicatedTenancyAccountType(dedicatedTenancyAccountType == null ? null : dedicatedTenancyAccountType.toString());
            return this;
        }

        @Override
        public DescribeAccountResponse build() {
            return new DescribeAccountResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccountResponse> {
        public Builder dedicatedTenancySupport(String var1);

        public Builder dedicatedTenancySupport(DedicatedTenancySupportResultEnum var1);

        public Builder dedicatedTenancyManagementCidrRange(String var1);

        public Builder dedicatedTenancyAccountType(String var1);

        public Builder dedicatedTenancyAccountType(DedicatedTenancyAccountType var1);
    }
}

