/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmailmessageflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmailmessageflow.model.RawMessageContent;
import software.amazon.awssdk.services.workmailmessageflow.model.WorkMailMessageFlowRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRawMessageContentRequest
extends WorkMailMessageFlowRequest
implements ToCopyableBuilder<Builder, PutRawMessageContentRequest> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageId").getter(PutRawMessageContentRequest.getter(PutRawMessageContentRequest::messageId)).setter(PutRawMessageContentRequest.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("messageId").build()}).build();
    private static final SdkField<RawMessageContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(PutRawMessageContentRequest.getter(PutRawMessageContentRequest::content)).setter(PutRawMessageContentRequest.setter(Builder::content)).constructor(RawMessageContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutRawMessageContentRequest.memberNameToFieldInitializer();
    private final String messageId;
    private final RawMessageContent content;

    private PutRawMessageContentRequest(BuilderImpl builder) {
        super(builder);
        this.messageId = builder.messageId;
        this.content = builder.content;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final RawMessageContent content() {
        return this.content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRawMessageContentRequest)) {
            return false;
        }
        PutRawMessageContentRequest other = (PutRawMessageContentRequest)((Object)obj);
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.content(), other.content());
    }

    public final String toString() {
        return ToString.builder((String)"PutRawMessageContentRequest").add("MessageId", (Object)this.messageId()).add("Content", (Object)this.content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("messageId", MESSAGE_ID_FIELD);
        map.put("content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRawMessageContentRequest, T> g) {
        return obj -> g.apply((PutRawMessageContentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailMessageFlowRequest.BuilderImpl
    implements Builder {
        private String messageId;
        private RawMessageContent content;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRawMessageContentRequest model) {
            super(model);
            this.messageId(model.messageId);
            this.content(model.content);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final RawMessageContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(RawMessageContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(RawMessageContent content) {
            this.content = content;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRawMessageContentRequest build() {
            return new PutRawMessageContentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkMailMessageFlowRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRawMessageContentRequest> {
        public Builder messageId(String var1);

        public Builder content(RawMessageContent var1);

        default public Builder content(Consumer<RawMessageContent.Builder> content) {
            return this.content((RawMessageContent)((RawMessageContent.Builder)RawMessageContent.builder().applyMutation(content)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

