/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.MobileDeviceAccessRuleEffect;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMobileDeviceAccessOverrideRequest
extends WorkMailRequest
implements ToCopyableBuilder<Builder, PutMobileDeviceAccessOverrideRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(PutMobileDeviceAccessOverrideRequest.getter(PutMobileDeviceAccessOverrideRequest::organizationId)).setter(PutMobileDeviceAccessOverrideRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(PutMobileDeviceAccessOverrideRequest.getter(PutMobileDeviceAccessOverrideRequest::userId)).setter(PutMobileDeviceAccessOverrideRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(PutMobileDeviceAccessOverrideRequest.getter(PutMobileDeviceAccessOverrideRequest::deviceId)).setter(PutMobileDeviceAccessOverrideRequest.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<String> EFFECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Effect").getter(PutMobileDeviceAccessOverrideRequest.getter(PutMobileDeviceAccessOverrideRequest::effectAsString)).setter(PutMobileDeviceAccessOverrideRequest.setter(Builder::effect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PutMobileDeviceAccessOverrideRequest.getter(PutMobileDeviceAccessOverrideRequest::description)).setter(PutMobileDeviceAccessOverrideRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, USER_ID_FIELD, DEVICE_ID_FIELD, EFFECT_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutMobileDeviceAccessOverrideRequest.memberNameToFieldInitializer();
    private final String organizationId;
    private final String userId;
    private final String deviceId;
    private final String effect;
    private final String description;

    private PutMobileDeviceAccessOverrideRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.userId = builder.userId;
        this.deviceId = builder.deviceId;
        this.effect = builder.effect;
        this.description = builder.description;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String userId() {
        return this.userId;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final MobileDeviceAccessRuleEffect effect() {
        return MobileDeviceAccessRuleEffect.fromValue(this.effect);
    }

    public final String effectAsString() {
        return this.effect;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMobileDeviceAccessOverrideRequest)) {
            return false;
        }
        PutMobileDeviceAccessOverrideRequest other = (PutMobileDeviceAccessOverrideRequest)((Object)obj);
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.effectAsString(), other.effectAsString()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"PutMobileDeviceAccessOverrideRequest").add("OrganizationId", (Object)this.organizationId()).add("UserId", (Object)this.userId()).add("DeviceId", (Object)this.deviceId()).add("Effect", (Object)this.effectAsString()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "Effect": {
                return Optional.ofNullable(clazz.cast(this.effectAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("DeviceId", DEVICE_ID_FIELD);
        map.put("Effect", EFFECT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutMobileDeviceAccessOverrideRequest, T> g) {
        return obj -> g.apply((PutMobileDeviceAccessOverrideRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailRequest.BuilderImpl
    implements Builder {
        private String organizationId;
        private String userId;
        private String deviceId;
        private String effect;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMobileDeviceAccessOverrideRequest model) {
            super(model);
            this.organizationId(model.organizationId);
            this.userId(model.userId);
            this.deviceId(model.deviceId);
            this.effect(model.effect);
            this.description(model.description);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getEffect() {
            return this.effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(MobileDeviceAccessRuleEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMobileDeviceAccessOverrideRequest build() {
            return new PutMobileDeviceAccessOverrideRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkMailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutMobileDeviceAccessOverrideRequest> {
        public Builder organizationId(String var1);

        public Builder userId(String var1);

        public Builder deviceId(String var1);

        public Builder effect(String var1);

        public Builder effect(MobileDeviceAccessRuleEffect var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

