/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.EntityState;
import software.amazon.awssdk.services.workmail.model.UserRole;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUserResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, DescribeUserResponse> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(DescribeUserResponse.getter(DescribeUserResponse::userId)).setter(DescribeUserResponse.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeUserResponse.getter(DescribeUserResponse::name)).setter(DescribeUserResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Email").getter(DescribeUserResponse.getter(DescribeUserResponse::email)).setter(DescribeUserResponse.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(DescribeUserResponse.getter(DescribeUserResponse::displayName)).setter(DescribeUserResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeUserResponse.getter(DescribeUserResponse::stateAsString)).setter(DescribeUserResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> USER_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserRole").getter(DescribeUserResponse.getter(DescribeUserResponse::userRoleAsString)).setter(DescribeUserResponse.setter(Builder::userRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRole").build()}).build();
    private static final SdkField<Instant> ENABLED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EnabledDate").getter(DescribeUserResponse.getter(DescribeUserResponse::enabledDate)).setter(DescribeUserResponse.setter(Builder::enabledDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledDate").build()}).build();
    private static final SdkField<Instant> DISABLED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DisabledDate").getter(DescribeUserResponse.getter(DescribeUserResponse::disabledDate)).setter(DescribeUserResponse.setter(Builder::disabledDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledDate").build()}).build();
    private static final SdkField<Instant> MAILBOX_PROVISIONED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("MailboxProvisionedDate").getter(DescribeUserResponse.getter(DescribeUserResponse::mailboxProvisionedDate)).setter(DescribeUserResponse.setter(Builder::mailboxProvisionedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailboxProvisionedDate").build()}).build();
    private static final SdkField<Instant> MAILBOX_DEPROVISIONED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("MailboxDeprovisionedDate").getter(DescribeUserResponse.getter(DescribeUserResponse::mailboxDeprovisionedDate)).setter(DescribeUserResponse.setter(Builder::mailboxDeprovisionedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailboxDeprovisionedDate").build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirstName").getter(DescribeUserResponse.getter(DescribeUserResponse::firstName)).setter(DescribeUserResponse.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastName").getter(DescribeUserResponse.getter(DescribeUserResponse::lastName)).setter(DescribeUserResponse.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()}).build();
    private static final SdkField<Boolean> HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HiddenFromGlobalAddressList").getter(DescribeUserResponse.getter(DescribeUserResponse::hiddenFromGlobalAddressList)).setter(DescribeUserResponse.setter(Builder::hiddenFromGlobalAddressList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenFromGlobalAddressList").build()}).build();
    private static final SdkField<String> INITIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Initials").getter(DescribeUserResponse.getter(DescribeUserResponse::initials)).setter(DescribeUserResponse.setter(Builder::initials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initials").build()}).build();
    private static final SdkField<String> TELEPHONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Telephone").getter(DescribeUserResponse.getter(DescribeUserResponse::telephone)).setter(DescribeUserResponse.setter(Builder::telephone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Telephone").build()}).build();
    private static final SdkField<String> STREET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Street").getter(DescribeUserResponse.getter(DescribeUserResponse::street)).setter(DescribeUserResponse.setter(Builder::street)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street").build()}).build();
    private static final SdkField<String> JOB_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobTitle").getter(DescribeUserResponse.getter(DescribeUserResponse::jobTitle)).setter(DescribeUserResponse.setter(Builder::jobTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTitle").build()}).build();
    private static final SdkField<String> CITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("City").getter(DescribeUserResponse.getter(DescribeUserResponse::city)).setter(DescribeUserResponse.setter(Builder::city)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()}).build();
    private static final SdkField<String> COMPANY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Company").getter(DescribeUserResponse.getter(DescribeUserResponse::company)).setter(DescribeUserResponse.setter(Builder::company)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Company").build()}).build();
    private static final SdkField<String> ZIP_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZipCode").getter(DescribeUserResponse.getter(DescribeUserResponse::zipCode)).setter(DescribeUserResponse.setter(Builder::zipCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipCode").build()}).build();
    private static final SdkField<String> DEPARTMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Department").getter(DescribeUserResponse.getter(DescribeUserResponse::department)).setter(DescribeUserResponse.setter(Builder::department)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Department").build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(DescribeUserResponse.getter(DescribeUserResponse::country)).setter(DescribeUserResponse.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<String> OFFICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Office").getter(DescribeUserResponse.getter(DescribeUserResponse::office)).setter(DescribeUserResponse.setter(Builder::office)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Office").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityProviderUserId").getter(DescribeUserResponse.getter(DescribeUserResponse::identityProviderUserId)).setter(DescribeUserResponse.setter(Builder::identityProviderUserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderUserId").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_IDENTITY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityProviderIdentityStoreId").getter(DescribeUserResponse.getter(DescribeUserResponse::identityProviderIdentityStoreId)).setter(DescribeUserResponse.setter(Builder::identityProviderIdentityStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderIdentityStoreId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, NAME_FIELD, EMAIL_FIELD, DISPLAY_NAME_FIELD, STATE_FIELD, USER_ROLE_FIELD, ENABLED_DATE_FIELD, DISABLED_DATE_FIELD, MAILBOX_PROVISIONED_DATE_FIELD, MAILBOX_DEPROVISIONED_DATE_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD, INITIALS_FIELD, TELEPHONE_FIELD, STREET_FIELD, JOB_TITLE_FIELD, CITY_FIELD, COMPANY_FIELD, ZIP_CODE_FIELD, DEPARTMENT_FIELD, COUNTRY_FIELD, OFFICE_FIELD, IDENTITY_PROVIDER_USER_ID_FIELD, IDENTITY_PROVIDER_IDENTITY_STORE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeUserResponse.memberNameToFieldInitializer();
    private final String userId;
    private final String name;
    private final String email;
    private final String displayName;
    private final String state;
    private final String userRole;
    private final Instant enabledDate;
    private final Instant disabledDate;
    private final Instant mailboxProvisionedDate;
    private final Instant mailboxDeprovisionedDate;
    private final String firstName;
    private final String lastName;
    private final Boolean hiddenFromGlobalAddressList;
    private final String initials;
    private final String telephone;
    private final String street;
    private final String jobTitle;
    private final String city;
    private final String company;
    private final String zipCode;
    private final String department;
    private final String country;
    private final String office;
    private final String identityProviderUserId;
    private final String identityProviderIdentityStoreId;

    private DescribeUserResponse(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.name = builder.name;
        this.email = builder.email;
        this.displayName = builder.displayName;
        this.state = builder.state;
        this.userRole = builder.userRole;
        this.enabledDate = builder.enabledDate;
        this.disabledDate = builder.disabledDate;
        this.mailboxProvisionedDate = builder.mailboxProvisionedDate;
        this.mailboxDeprovisionedDate = builder.mailboxDeprovisionedDate;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.hiddenFromGlobalAddressList = builder.hiddenFromGlobalAddressList;
        this.initials = builder.initials;
        this.telephone = builder.telephone;
        this.street = builder.street;
        this.jobTitle = builder.jobTitle;
        this.city = builder.city;
        this.company = builder.company;
        this.zipCode = builder.zipCode;
        this.department = builder.department;
        this.country = builder.country;
        this.office = builder.office;
        this.identityProviderUserId = builder.identityProviderUserId;
        this.identityProviderIdentityStoreId = builder.identityProviderIdentityStoreId;
    }

    public final String userId() {
        return this.userId;
    }

    public final String name() {
        return this.name;
    }

    public final String email() {
        return this.email;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final EntityState state() {
        return EntityState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final UserRole userRole() {
        return UserRole.fromValue(this.userRole);
    }

    public final String userRoleAsString() {
        return this.userRole;
    }

    public final Instant enabledDate() {
        return this.enabledDate;
    }

    public final Instant disabledDate() {
        return this.disabledDate;
    }

    public final Instant mailboxProvisionedDate() {
        return this.mailboxProvisionedDate;
    }

    public final Instant mailboxDeprovisionedDate() {
        return this.mailboxDeprovisionedDate;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public final Boolean hiddenFromGlobalAddressList() {
        return this.hiddenFromGlobalAddressList;
    }

    public final String initials() {
        return this.initials;
    }

    public final String telephone() {
        return this.telephone;
    }

    public final String street() {
        return this.street;
    }

    public final String jobTitle() {
        return this.jobTitle;
    }

    public final String city() {
        return this.city;
    }

    public final String company() {
        return this.company;
    }

    public final String zipCode() {
        return this.zipCode;
    }

    public final String department() {
        return this.department;
    }

    public final String country() {
        return this.country;
    }

    public final String office() {
        return this.office;
    }

    public final String identityProviderUserId() {
        return this.identityProviderUserId;
    }

    public final String identityProviderIdentityStoreId() {
        return this.identityProviderIdentityStoreId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabledDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.mailboxProvisionedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.mailboxDeprovisionedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hiddenFromGlobalAddressList());
        hashCode = 31 * hashCode + Objects.hashCode(this.initials());
        hashCode = 31 * hashCode + Objects.hashCode(this.telephone());
        hashCode = 31 * hashCode + Objects.hashCode(this.street());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.company());
        hashCode = 31 * hashCode + Objects.hashCode(this.zipCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.department());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.office());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderUserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderIdentityStoreId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserResponse)) {
            return false;
        }
        DescribeUserResponse other = (DescribeUserResponse)((Object)obj);
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.userRoleAsString(), other.userRoleAsString()) && Objects.equals(this.enabledDate(), other.enabledDate()) && Objects.equals(this.disabledDate(), other.disabledDate()) && Objects.equals(this.mailboxProvisionedDate(), other.mailboxProvisionedDate()) && Objects.equals(this.mailboxDeprovisionedDate(), other.mailboxDeprovisionedDate()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.hiddenFromGlobalAddressList(), other.hiddenFromGlobalAddressList()) && Objects.equals(this.initials(), other.initials()) && Objects.equals(this.telephone(), other.telephone()) && Objects.equals(this.street(), other.street()) && Objects.equals(this.jobTitle(), other.jobTitle()) && Objects.equals(this.city(), other.city()) && Objects.equals(this.company(), other.company()) && Objects.equals(this.zipCode(), other.zipCode()) && Objects.equals(this.department(), other.department()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.office(), other.office()) && Objects.equals(this.identityProviderUserId(), other.identityProviderUserId()) && Objects.equals(this.identityProviderIdentityStoreId(), other.identityProviderIdentityStoreId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeUserResponse").add("UserId", (Object)this.userId()).add("Name", (Object)this.name()).add("Email", (Object)this.email()).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("State", (Object)this.stateAsString()).add("UserRole", (Object)this.userRoleAsString()).add("EnabledDate", (Object)this.enabledDate()).add("DisabledDate", (Object)this.disabledDate()).add("MailboxProvisionedDate", (Object)this.mailboxProvisionedDate()).add("MailboxDeprovisionedDate", (Object)this.mailboxDeprovisionedDate()).add("FirstName", (Object)(this.firstName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastName", (Object)(this.lastName() == null ? null : "*** Sensitive Data Redacted ***")).add("HiddenFromGlobalAddressList", (Object)this.hiddenFromGlobalAddressList()).add("Initials", (Object)(this.initials() == null ? null : "*** Sensitive Data Redacted ***")).add("Telephone", (Object)(this.telephone() == null ? null : "*** Sensitive Data Redacted ***")).add("Street", (Object)(this.street() == null ? null : "*** Sensitive Data Redacted ***")).add("JobTitle", (Object)(this.jobTitle() == null ? null : "*** Sensitive Data Redacted ***")).add("City", (Object)(this.city() == null ? null : "*** Sensitive Data Redacted ***")).add("Company", (Object)(this.company() == null ? null : "*** Sensitive Data Redacted ***")).add("ZipCode", (Object)(this.zipCode() == null ? null : "*** Sensitive Data Redacted ***")).add("Department", (Object)(this.department() == null ? null : "*** Sensitive Data Redacted ***")).add("Country", (Object)(this.country() == null ? null : "*** Sensitive Data Redacted ***")).add("Office", (Object)(this.office() == null ? null : "*** Sensitive Data Redacted ***")).add("IdentityProviderUserId", (Object)this.identityProviderUserId()).add("IdentityProviderIdentityStoreId", (Object)this.identityProviderIdentityStoreId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "UserRole": {
                return Optional.ofNullable(clazz.cast(this.userRoleAsString()));
            }
            case "EnabledDate": {
                return Optional.ofNullable(clazz.cast(this.enabledDate()));
            }
            case "DisabledDate": {
                return Optional.ofNullable(clazz.cast(this.disabledDate()));
            }
            case "MailboxProvisionedDate": {
                return Optional.ofNullable(clazz.cast(this.mailboxProvisionedDate()));
            }
            case "MailboxDeprovisionedDate": {
                return Optional.ofNullable(clazz.cast(this.mailboxDeprovisionedDate()));
            }
            case "FirstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "LastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "HiddenFromGlobalAddressList": {
                return Optional.ofNullable(clazz.cast(this.hiddenFromGlobalAddressList()));
            }
            case "Initials": {
                return Optional.ofNullable(clazz.cast(this.initials()));
            }
            case "Telephone": {
                return Optional.ofNullable(clazz.cast(this.telephone()));
            }
            case "Street": {
                return Optional.ofNullable(clazz.cast(this.street()));
            }
            case "JobTitle": {
                return Optional.ofNullable(clazz.cast(this.jobTitle()));
            }
            case "City": {
                return Optional.ofNullable(clazz.cast(this.city()));
            }
            case "Company": {
                return Optional.ofNullable(clazz.cast(this.company()));
            }
            case "ZipCode": {
                return Optional.ofNullable(clazz.cast(this.zipCode()));
            }
            case "Department": {
                return Optional.ofNullable(clazz.cast(this.department()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Office": {
                return Optional.ofNullable(clazz.cast(this.office()));
            }
            case "IdentityProviderUserId": {
                return Optional.ofNullable(clazz.cast(this.identityProviderUserId()));
            }
            case "IdentityProviderIdentityStoreId": {
                return Optional.ofNullable(clazz.cast(this.identityProviderIdentityStoreId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserId", USER_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Email", EMAIL_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("UserRole", USER_ROLE_FIELD);
        map.put("EnabledDate", ENABLED_DATE_FIELD);
        map.put("DisabledDate", DISABLED_DATE_FIELD);
        map.put("MailboxProvisionedDate", MAILBOX_PROVISIONED_DATE_FIELD);
        map.put("MailboxDeprovisionedDate", MAILBOX_DEPROVISIONED_DATE_FIELD);
        map.put("FirstName", FIRST_NAME_FIELD);
        map.put("LastName", LAST_NAME_FIELD);
        map.put("HiddenFromGlobalAddressList", HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD);
        map.put("Initials", INITIALS_FIELD);
        map.put("Telephone", TELEPHONE_FIELD);
        map.put("Street", STREET_FIELD);
        map.put("JobTitle", JOB_TITLE_FIELD);
        map.put("City", CITY_FIELD);
        map.put("Company", COMPANY_FIELD);
        map.put("ZipCode", ZIP_CODE_FIELD);
        map.put("Department", DEPARTMENT_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("Office", OFFICE_FIELD);
        map.put("IdentityProviderUserId", IDENTITY_PROVIDER_USER_ID_FIELD);
        map.put("IdentityProviderIdentityStoreId", IDENTITY_PROVIDER_IDENTITY_STORE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserResponse, T> g) {
        return obj -> g.apply((DescribeUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private String userId;
        private String name;
        private String email;
        private String displayName;
        private String state;
        private String userRole;
        private Instant enabledDate;
        private Instant disabledDate;
        private Instant mailboxProvisionedDate;
        private Instant mailboxDeprovisionedDate;
        private String firstName;
        private String lastName;
        private Boolean hiddenFromGlobalAddressList;
        private String initials;
        private String telephone;
        private String street;
        private String jobTitle;
        private String city;
        private String company;
        private String zipCode;
        private String department;
        private String country;
        private String office;
        private String identityProviderUserId;
        private String identityProviderIdentityStoreId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserResponse model) {
            super(model);
            this.userId(model.userId);
            this.name(model.name);
            this.email(model.email);
            this.displayName(model.displayName);
            this.state(model.state);
            this.userRole(model.userRole);
            this.enabledDate(model.enabledDate);
            this.disabledDate(model.disabledDate);
            this.mailboxProvisionedDate(model.mailboxProvisionedDate);
            this.mailboxDeprovisionedDate(model.mailboxDeprovisionedDate);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.hiddenFromGlobalAddressList(model.hiddenFromGlobalAddressList);
            this.initials(model.initials);
            this.telephone(model.telephone);
            this.street(model.street);
            this.jobTitle(model.jobTitle);
            this.city(model.city);
            this.company(model.company);
            this.zipCode(model.zipCode);
            this.department(model.department);
            this.country(model.country);
            this.office(model.office);
            this.identityProviderUserId(model.identityProviderUserId);
            this.identityProviderIdentityStoreId(model.identityProviderIdentityStoreId);
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EntityState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getUserRole() {
            return this.userRole;
        }

        public final void setUserRole(String userRole) {
            this.userRole = userRole;
        }

        @Override
        public final Builder userRole(String userRole) {
            this.userRole = userRole;
            return this;
        }

        @Override
        public final Builder userRole(UserRole userRole) {
            this.userRole(userRole == null ? null : userRole.toString());
            return this;
        }

        public final Instant getEnabledDate() {
            return this.enabledDate;
        }

        public final void setEnabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
        }

        @Override
        public final Builder enabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
            return this;
        }

        public final Instant getDisabledDate() {
            return this.disabledDate;
        }

        public final void setDisabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
        }

        @Override
        public final Builder disabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
            return this;
        }

        public final Instant getMailboxProvisionedDate() {
            return this.mailboxProvisionedDate;
        }

        public final void setMailboxProvisionedDate(Instant mailboxProvisionedDate) {
            this.mailboxProvisionedDate = mailboxProvisionedDate;
        }

        @Override
        public final Builder mailboxProvisionedDate(Instant mailboxProvisionedDate) {
            this.mailboxProvisionedDate = mailboxProvisionedDate;
            return this;
        }

        public final Instant getMailboxDeprovisionedDate() {
            return this.mailboxDeprovisionedDate;
        }

        public final void setMailboxDeprovisionedDate(Instant mailboxDeprovisionedDate) {
            this.mailboxDeprovisionedDate = mailboxDeprovisionedDate;
        }

        @Override
        public final Builder mailboxDeprovisionedDate(Instant mailboxDeprovisionedDate) {
            this.mailboxDeprovisionedDate = mailboxDeprovisionedDate;
            return this;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final Boolean getHiddenFromGlobalAddressList() {
            return this.hiddenFromGlobalAddressList;
        }

        public final void setHiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
        }

        @Override
        public final Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
            return this;
        }

        public final String getInitials() {
            return this.initials;
        }

        public final void setInitials(String initials) {
            this.initials = initials;
        }

        @Override
        public final Builder initials(String initials) {
            this.initials = initials;
            return this;
        }

        public final String getTelephone() {
            return this.telephone;
        }

        public final void setTelephone(String telephone) {
            this.telephone = telephone;
        }

        @Override
        public final Builder telephone(String telephone) {
            this.telephone = telephone;
            return this;
        }

        public final String getStreet() {
            return this.street;
        }

        public final void setStreet(String street) {
            this.street = street;
        }

        @Override
        public final Builder street(String street) {
            this.street = street;
            return this;
        }

        public final String getJobTitle() {
            return this.jobTitle;
        }

        public final void setJobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
        }

        @Override
        public final Builder jobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        public final String getCity() {
            return this.city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCompany() {
            return this.company;
        }

        public final void setCompany(String company) {
            this.company = company;
        }

        @Override
        public final Builder company(String company) {
            this.company = company;
            return this;
        }

        public final String getZipCode() {
            return this.zipCode;
        }

        public final void setZipCode(String zipCode) {
            this.zipCode = zipCode;
        }

        @Override
        public final Builder zipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public final String getDepartment() {
            return this.department;
        }

        public final void setDepartment(String department) {
            this.department = department;
        }

        @Override
        public final Builder department(String department) {
            this.department = department;
            return this;
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getOffice() {
            return this.office;
        }

        public final void setOffice(String office) {
            this.office = office;
        }

        @Override
        public final Builder office(String office) {
            this.office = office;
            return this;
        }

        public final String getIdentityProviderUserId() {
            return this.identityProviderUserId;
        }

        public final void setIdentityProviderUserId(String identityProviderUserId) {
            this.identityProviderUserId = identityProviderUserId;
        }

        @Override
        public final Builder identityProviderUserId(String identityProviderUserId) {
            this.identityProviderUserId = identityProviderUserId;
            return this;
        }

        public final String getIdentityProviderIdentityStoreId() {
            return this.identityProviderIdentityStoreId;
        }

        public final void setIdentityProviderIdentityStoreId(String identityProviderIdentityStoreId) {
            this.identityProviderIdentityStoreId = identityProviderIdentityStoreId;
        }

        @Override
        public final Builder identityProviderIdentityStoreId(String identityProviderIdentityStoreId) {
            this.identityProviderIdentityStoreId = identityProviderIdentityStoreId;
            return this;
        }

        @Override
        public DescribeUserResponse build() {
            return new DescribeUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUserResponse> {
        public Builder userId(String var1);

        public Builder name(String var1);

        public Builder email(String var1);

        public Builder displayName(String var1);

        public Builder state(String var1);

        public Builder state(EntityState var1);

        public Builder userRole(String var1);

        public Builder userRole(UserRole var1);

        public Builder enabledDate(Instant var1);

        public Builder disabledDate(Instant var1);

        public Builder mailboxProvisionedDate(Instant var1);

        public Builder mailboxDeprovisionedDate(Instant var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder hiddenFromGlobalAddressList(Boolean var1);

        public Builder initials(String var1);

        public Builder telephone(String var1);

        public Builder street(String var1);

        public Builder jobTitle(String var1);

        public Builder city(String var1);

        public Builder company(String var1);

        public Builder zipCode(String var1);

        public Builder department(String var1);

        public Builder country(String var1);

        public Builder office(String var1);

        public Builder identityProviderUserId(String var1);

        public Builder identityProviderIdentityStoreId(String var1);
    }
}

