/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.MobileDeviceAccessRule;
import software.amazon.awssdk.services.workmail.model.MobileDeviceAccessRulesListCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMobileDeviceAccessRulesResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, ListMobileDeviceAccessRulesResponse> {
    private static final SdkField<List<MobileDeviceAccessRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(ListMobileDeviceAccessRulesResponse.getter(ListMobileDeviceAccessRulesResponse::rules)).setter(ListMobileDeviceAccessRulesResponse.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MobileDeviceAccessRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMobileDeviceAccessRulesResponse.memberNameToFieldInitializer();
    private final List<MobileDeviceAccessRule> rules;

    private ListMobileDeviceAccessRulesResponse(BuilderImpl builder) {
        super(builder);
        this.rules = builder.rules;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<MobileDeviceAccessRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMobileDeviceAccessRulesResponse)) {
            return false;
        }
        ListMobileDeviceAccessRulesResponse other = (ListMobileDeviceAccessRulesResponse)((Object)obj);
        return this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules());
    }

    public final String toString() {
        return ToString.builder((String)"ListMobileDeviceAccessRulesResponse").add("Rules", this.hasRules() ? this.rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<MobileDeviceAccessRule>>> map = new HashMap<String, SdkField<List<MobileDeviceAccessRule>>>();
        map.put("Rules", RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMobileDeviceAccessRulesResponse, T> g) {
        return obj -> g.apply((ListMobileDeviceAccessRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private List<MobileDeviceAccessRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMobileDeviceAccessRulesResponse model) {
            super(model);
            this.rules(model.rules);
        }

        public final List<MobileDeviceAccessRule.Builder> getRules() {
            List<MobileDeviceAccessRule.Builder> result = MobileDeviceAccessRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<MobileDeviceAccessRule.BuilderImpl> rules) {
            this.rules = MobileDeviceAccessRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<MobileDeviceAccessRule> rules) {
            this.rules = MobileDeviceAccessRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(MobileDeviceAccessRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<MobileDeviceAccessRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (MobileDeviceAccessRule)((MobileDeviceAccessRule.Builder)MobileDeviceAccessRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMobileDeviceAccessRulesResponse build() {
            return new ListMobileDeviceAccessRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMobileDeviceAccessRulesResponse> {
        public Builder rules(Collection<MobileDeviceAccessRule> var1);

        public Builder rules(MobileDeviceAccessRule ... var1);

        public Builder rules(Consumer<MobileDeviceAccessRule.Builder> ... var1);
    }
}

