/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailAsyncClient;
import software.amazon.awssdk.services.workmail.internal.UserAgentUtils;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesResponse;

public class ListMobileDeviceAccessOverridesPublisher
implements SdkPublisher<ListMobileDeviceAccessOverridesResponse> {
    private final WorkMailAsyncClient client;
    private final ListMobileDeviceAccessOverridesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMobileDeviceAccessOverridesPublisher(WorkMailAsyncClient client, ListMobileDeviceAccessOverridesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMobileDeviceAccessOverridesPublisher(WorkMailAsyncClient client, ListMobileDeviceAccessOverridesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMobileDeviceAccessOverridesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMobileDeviceAccessOverridesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMobileDeviceAccessOverridesResponseFetcher
    implements AsyncPageFetcher<ListMobileDeviceAccessOverridesResponse> {
        private ListMobileDeviceAccessOverridesResponseFetcher() {
        }

        public boolean hasNextPage(ListMobileDeviceAccessOverridesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMobileDeviceAccessOverridesResponse> nextPage(ListMobileDeviceAccessOverridesResponse previousPage) {
            if (previousPage == null) {
                return ListMobileDeviceAccessOverridesPublisher.this.client.listMobileDeviceAccessOverrides(ListMobileDeviceAccessOverridesPublisher.this.firstRequest);
            }
            return ListMobileDeviceAccessOverridesPublisher.this.client.listMobileDeviceAccessOverrides((ListMobileDeviceAccessOverridesRequest)((Object)ListMobileDeviceAccessOverridesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

