/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailClient;
import software.amazon.awssdk.services.workmail.internal.UserAgentUtils;
import software.amazon.awssdk.services.workmail.model.ListPersonalAccessTokensRequest;
import software.amazon.awssdk.services.workmail.model.ListPersonalAccessTokensResponse;
import software.amazon.awssdk.services.workmail.model.PersonalAccessTokenSummary;

public class ListPersonalAccessTokensIterable
implements SdkIterable<ListPersonalAccessTokensResponse> {
    private final WorkMailClient client;
    private final ListPersonalAccessTokensRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPersonalAccessTokensIterable(WorkMailClient client, ListPersonalAccessTokensRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPersonalAccessTokensResponseFetcher();
    }

    public Iterator<ListPersonalAccessTokensResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PersonalAccessTokenSummary> personalAccessTokenSummaries() {
        Function<ListPersonalAccessTokensResponse, Iterator> getIterator = response -> {
            if (response != null && response.personalAccessTokenSummaries() != null) {
                return response.personalAccessTokenSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPersonalAccessTokensResponseFetcher
    implements SyncPageFetcher<ListPersonalAccessTokensResponse> {
        private ListPersonalAccessTokensResponseFetcher() {
        }

        public boolean hasNextPage(ListPersonalAccessTokensResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPersonalAccessTokensResponse nextPage(ListPersonalAccessTokensResponse previousPage) {
            if (previousPage == null) {
                return ListPersonalAccessTokensIterable.this.client.listPersonalAccessTokens(ListPersonalAccessTokensIterable.this.firstRequest);
            }
            return ListPersonalAccessTokensIterable.this.client.listPersonalAccessTokens((ListPersonalAccessTokensRequest)((Object)ListPersonalAccessTokensIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

