/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailClient;
import software.amazon.awssdk.services.workmail.internal.UserAgentUtils;
import software.amazon.awssdk.services.workmail.model.AvailabilityConfiguration;
import software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsRequest;
import software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsResponse;

public class ListAvailabilityConfigurationsIterable
implements SdkIterable<ListAvailabilityConfigurationsResponse> {
    private final WorkMailClient client;
    private final ListAvailabilityConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAvailabilityConfigurationsIterable(WorkMailClient client, ListAvailabilityConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAvailabilityConfigurationsResponseFetcher();
    }

    public Iterator<ListAvailabilityConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AvailabilityConfiguration> availabilityConfigurations() {
        Function<ListAvailabilityConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.availabilityConfigurations() != null) {
                return response.availabilityConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAvailabilityConfigurationsResponseFetcher
    implements SyncPageFetcher<ListAvailabilityConfigurationsResponse> {
        private ListAvailabilityConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAvailabilityConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAvailabilityConfigurationsResponse nextPage(ListAvailabilityConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListAvailabilityConfigurationsIterable.this.client.listAvailabilityConfigurations(ListAvailabilityConfigurationsIterable.this.firstRequest);
            }
            return ListAvailabilityConfigurationsIterable.this.client.listAvailabilityConfigurations((ListAvailabilityConfigurationsRequest)((Object)ListAvailabilityConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

