/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.AvailabilityConfiguration;
import software.amazon.awssdk.services.workmail.model.AvailabilityConfigurationListCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAvailabilityConfigurationsResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, ListAvailabilityConfigurationsResponse> {
    private static final SdkField<List<AvailabilityConfiguration>> AVAILABILITY_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityConfigurations").getter(ListAvailabilityConfigurationsResponse.getter(ListAvailabilityConfigurationsResponse::availabilityConfigurations)).setter(ListAvailabilityConfigurationsResponse.setter(Builder::availabilityConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailabilityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAvailabilityConfigurationsResponse.getter(ListAvailabilityConfigurationsResponse::nextToken)).setter(ListAvailabilityConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAvailabilityConfigurationsResponse.memberNameToFieldInitializer();
    private final List<AvailabilityConfiguration> availabilityConfigurations;
    private final String nextToken;

    private ListAvailabilityConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.availabilityConfigurations = builder.availabilityConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAvailabilityConfigurations() {
        return this.availabilityConfigurations != null && !(this.availabilityConfigurations instanceof SdkAutoConstructList);
    }

    public final List<AvailabilityConfiguration> availabilityConfigurations() {
        return this.availabilityConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityConfigurations() ? this.availabilityConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailabilityConfigurationsResponse)) {
            return false;
        }
        ListAvailabilityConfigurationsResponse other = (ListAvailabilityConfigurationsResponse)((Object)obj);
        return this.hasAvailabilityConfigurations() == other.hasAvailabilityConfigurations() && Objects.equals(this.availabilityConfigurations(), other.availabilityConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAvailabilityConfigurationsResponse").add("AvailabilityConfigurations", this.hasAvailabilityConfigurations() ? this.availabilityConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityConfigurations": {
                return Optional.ofNullable(clazz.cast(this.availabilityConfigurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailabilityConfigurations", AVAILABILITY_CONFIGURATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAvailabilityConfigurationsResponse, T> g) {
        return obj -> g.apply((ListAvailabilityConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private List<AvailabilityConfiguration> availabilityConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailabilityConfigurationsResponse model) {
            super(model);
            this.availabilityConfigurations(model.availabilityConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<AvailabilityConfiguration.Builder> getAvailabilityConfigurations() {
            List<AvailabilityConfiguration.Builder> result = AvailabilityConfigurationListCopier.copyToBuilder(this.availabilityConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityConfigurations(Collection<AvailabilityConfiguration.BuilderImpl> availabilityConfigurations) {
            this.availabilityConfigurations = AvailabilityConfigurationListCopier.copyFromBuilder(availabilityConfigurations);
        }

        @Override
        public final Builder availabilityConfigurations(Collection<AvailabilityConfiguration> availabilityConfigurations) {
            this.availabilityConfigurations = AvailabilityConfigurationListCopier.copy(availabilityConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityConfigurations(AvailabilityConfiguration ... availabilityConfigurations) {
            this.availabilityConfigurations(Arrays.asList(availabilityConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityConfigurations(Consumer<AvailabilityConfiguration.Builder> ... availabilityConfigurations) {
            this.availabilityConfigurations(Stream.of(availabilityConfigurations).map(c -> (AvailabilityConfiguration)((AvailabilityConfiguration.Builder)AvailabilityConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAvailabilityConfigurationsResponse build() {
            return new ListAvailabilityConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAvailabilityConfigurationsResponse> {
        public Builder availabilityConfigurations(Collection<AvailabilityConfiguration> var1);

        public Builder availabilityConfigurations(AvailabilityConfiguration ... var1);

        public Builder availabilityConfigurations(Consumer<AvailabilityConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

