/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.worklink.model.IdentityProviderType;
import software.amazon.awssdk.services.worklink.model.WorkLinkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIdentityProviderConfigurationRequest
extends WorkLinkRequest
implements ToCopyableBuilder<Builder, UpdateIdentityProviderConfigurationRequest> {
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(UpdateIdentityProviderConfigurationRequest.getter(UpdateIdentityProviderConfigurationRequest::fleetArn)).setter(UpdateIdentityProviderConfigurationRequest.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityProviderType").getter(UpdateIdentityProviderConfigurationRequest.getter(UpdateIdentityProviderConfigurationRequest::identityProviderTypeAsString)).setter(UpdateIdentityProviderConfigurationRequest.setter(Builder::identityProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderType").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_SAML_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityProviderSamlMetadata").getter(UpdateIdentityProviderConfigurationRequest.getter(UpdateIdentityProviderConfigurationRequest::identityProviderSamlMetadata)).setter(UpdateIdentityProviderConfigurationRequest.setter(Builder::identityProviderSamlMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderSamlMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ARN_FIELD, IDENTITY_PROVIDER_TYPE_FIELD, IDENTITY_PROVIDER_SAML_METADATA_FIELD));
    private final String fleetArn;
    private final String identityProviderType;
    private final String identityProviderSamlMetadata;

    private UpdateIdentityProviderConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.fleetArn = builder.fleetArn;
        this.identityProviderType = builder.identityProviderType;
        this.identityProviderSamlMetadata = builder.identityProviderSamlMetadata;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(this.identityProviderType);
    }

    public final String identityProviderTypeAsString() {
        return this.identityProviderType;
    }

    public final String identityProviderSamlMetadata() {
        return this.identityProviderSamlMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderSamlMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdentityProviderConfigurationRequest)) {
            return false;
        }
        UpdateIdentityProviderConfigurationRequest other = (UpdateIdentityProviderConfigurationRequest)((Object)obj);
        return Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.identityProviderTypeAsString(), other.identityProviderTypeAsString()) && Objects.equals(this.identityProviderSamlMetadata(), other.identityProviderSamlMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIdentityProviderConfigurationRequest").add("FleetArn", (Object)this.fleetArn()).add("IdentityProviderType", (Object)this.identityProviderTypeAsString()).add("IdentityProviderSamlMetadata", (Object)this.identityProviderSamlMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "IdentityProviderType": {
                return Optional.ofNullable(clazz.cast(this.identityProviderTypeAsString()));
            }
            case "IdentityProviderSamlMetadata": {
                return Optional.ofNullable(clazz.cast(this.identityProviderSamlMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdentityProviderConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateIdentityProviderConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkLinkRequest.BuilderImpl
    implements Builder {
        private String fleetArn;
        private String identityProviderType;
        private String identityProviderSamlMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdentityProviderConfigurationRequest model) {
            super(model);
            this.fleetArn(model.fleetArn);
            this.identityProviderType(model.identityProviderType);
            this.identityProviderSamlMetadata(model.identityProviderSamlMetadata);
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        @Transient
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getIdentityProviderType() {
            return this.identityProviderType;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        @Override
        @Transient
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        @Transient
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType == null ? null : identityProviderType.toString());
            return this;
        }

        public final String getIdentityProviderSamlMetadata() {
            return this.identityProviderSamlMetadata;
        }

        public final void setIdentityProviderSamlMetadata(String identityProviderSamlMetadata) {
            this.identityProviderSamlMetadata = identityProviderSamlMetadata;
        }

        @Override
        @Transient
        public final Builder identityProviderSamlMetadata(String identityProviderSamlMetadata) {
            this.identityProviderSamlMetadata = identityProviderSamlMetadata;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIdentityProviderConfigurationRequest build() {
            return new UpdateIdentityProviderConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkLinkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIdentityProviderConfigurationRequest> {
        public Builder fleetArn(String var1);

        public Builder identityProviderType(String var1);

        public Builder identityProviderType(IdentityProviderType var1);

        public Builder identityProviderSamlMetadata(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

