/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.worklink.model.WorkLinkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAuditStreamConfigurationRequest
extends WorkLinkRequest
implements ToCopyableBuilder<Builder, UpdateAuditStreamConfigurationRequest> {
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(UpdateAuditStreamConfigurationRequest.getter(UpdateAuditStreamConfigurationRequest::fleetArn)).setter(UpdateAuditStreamConfigurationRequest.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<String> AUDIT_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuditStreamArn").getter(UpdateAuditStreamConfigurationRequest.getter(UpdateAuditStreamConfigurationRequest::auditStreamArn)).setter(UpdateAuditStreamConfigurationRequest.setter(Builder::auditStreamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditStreamArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ARN_FIELD, AUDIT_STREAM_ARN_FIELD));
    private final String fleetArn;
    private final String auditStreamArn;

    private UpdateAuditStreamConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.fleetArn = builder.fleetArn;
        this.auditStreamArn = builder.auditStreamArn;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final String auditStreamArn() {
        return this.auditStreamArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditStreamArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAuditStreamConfigurationRequest)) {
            return false;
        }
        UpdateAuditStreamConfigurationRequest other = (UpdateAuditStreamConfigurationRequest)((Object)obj);
        return Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.auditStreamArn(), other.auditStreamArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAuditStreamConfigurationRequest").add("FleetArn", (Object)this.fleetArn()).add("AuditStreamArn", (Object)this.auditStreamArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "AuditStreamArn": {
                return Optional.ofNullable(clazz.cast(this.auditStreamArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAuditStreamConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateAuditStreamConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkLinkRequest.BuilderImpl
    implements Builder {
        private String fleetArn;
        private String auditStreamArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAuditStreamConfigurationRequest model) {
            super(model);
            this.fleetArn(model.fleetArn);
            this.auditStreamArn(model.auditStreamArn);
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        @Transient
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getAuditStreamArn() {
            return this.auditStreamArn;
        }

        public final void setAuditStreamArn(String auditStreamArn) {
            this.auditStreamArn = auditStreamArn;
        }

        @Override
        @Transient
        public final Builder auditStreamArn(String auditStreamArn) {
            this.auditStreamArn = auditStreamArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAuditStreamConfigurationRequest build() {
            return new UpdateAuditStreamConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkLinkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAuditStreamConfigurationRequest> {
        public Builder fleetArn(String var1);

        public Builder auditStreamArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

