/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeviceResponse extends WorkLinkResponse implements
        ToCopyableBuilder<DescribeDeviceResponse.Builder, DescribeDeviceResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeDeviceResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Model")
            .getter(getter(DescribeDeviceResponse::model)).setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()).build();

    private static final SdkField<String> MANUFACTURER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Manufacturer").getter(getter(DescribeDeviceResponse::manufacturer))
            .setter(setter(Builder::manufacturer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Manufacturer").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatingSystem").getter(getter(DescribeDeviceResponse::operatingSystem))
            .setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatingSystemVersion").getter(getter(DescribeDeviceResponse::operatingSystemVersion))
            .setter(setter(Builder::operatingSystemVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemVersion").build())
            .build();

    private static final SdkField<String> PATCH_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatchLevel").getter(getter(DescribeDeviceResponse::patchLevel)).setter(setter(Builder::patchLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchLevel").build()).build();

    private static final SdkField<Instant> FIRST_ACCESSED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FirstAccessedTime").getter(getter(DescribeDeviceResponse::firstAccessedTime))
            .setter(setter(Builder::firstAccessedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstAccessedTime").build()).build();

    private static final SdkField<Instant> LAST_ACCESSED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAccessedTime").getter(getter(DescribeDeviceResponse::lastAccessedTime))
            .setter(setter(Builder::lastAccessedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessedTime").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(DescribeDeviceResponse::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, MODEL_FIELD,
            MANUFACTURER_FIELD, OPERATING_SYSTEM_FIELD, OPERATING_SYSTEM_VERSION_FIELD, PATCH_LEVEL_FIELD,
            FIRST_ACCESSED_TIME_FIELD, LAST_ACCESSED_TIME_FIELD, USERNAME_FIELD));

    private final String status;

    private final String model;

    private final String manufacturer;

    private final String operatingSystem;

    private final String operatingSystemVersion;

    private final String patchLevel;

    private final Instant firstAccessedTime;

    private final Instant lastAccessedTime;

    private final String username;

    private DescribeDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.model = builder.model;
        this.manufacturer = builder.manufacturer;
        this.operatingSystem = builder.operatingSystem;
        this.operatingSystemVersion = builder.operatingSystemVersion;
        this.patchLevel = builder.patchLevel;
        this.firstAccessedTime = builder.firstAccessedTime;
        this.lastAccessedTime = builder.lastAccessedTime;
        this.username = builder.username;
    }

    /**
     * <p>
     * The current state of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the device.
     * @see DeviceStatus
     */
    public final DeviceStatus status() {
        return DeviceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the device.
     * @see DeviceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The model of the device.
     * </p>
     * 
     * @return The model of the device.
     */
    public final String model() {
        return model;
    }

    /**
     * <p>
     * The manufacturer of the device.
     * </p>
     * 
     * @return The manufacturer of the device.
     */
    public final String manufacturer() {
        return manufacturer;
    }

    /**
     * <p>
     * The operating system of the device.
     * </p>
     * 
     * @return The operating system of the device.
     */
    public final String operatingSystem() {
        return operatingSystem;
    }

    /**
     * <p>
     * The operating system version of the device.
     * </p>
     * 
     * @return The operating system version of the device.
     */
    public final String operatingSystemVersion() {
        return operatingSystemVersion;
    }

    /**
     * <p>
     * The operating system patch level of the device.
     * </p>
     * 
     * @return The operating system patch level of the device.
     */
    public final String patchLevel() {
        return patchLevel;
    }

    /**
     * <p>
     * The date that the device first signed in to Amazon WorkLink.
     * </p>
     * 
     * @return The date that the device first signed in to Amazon WorkLink.
     */
    public final Instant firstAccessedTime() {
        return firstAccessedTime;
    }

    /**
     * <p>
     * The date that the device last accessed Amazon WorkLink.
     * </p>
     * 
     * @return The date that the device last accessed Amazon WorkLink.
     */
    public final Instant lastAccessedTime() {
        return lastAccessedTime;
    }

    /**
     * <p>
     * The user name associated with the device.
     * </p>
     * 
     * @return The user name associated with the device.
     */
    public final String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(manufacturer());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystem());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemVersion());
        hashCode = 31 * hashCode + Objects.hashCode(patchLevel());
        hashCode = 31 * hashCode + Objects.hashCode(firstAccessedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastAccessedTime());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceResponse)) {
            return false;
        }
        DescribeDeviceResponse other = (DescribeDeviceResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(model(), other.model())
                && Objects.equals(manufacturer(), other.manufacturer())
                && Objects.equals(operatingSystem(), other.operatingSystem())
                && Objects.equals(operatingSystemVersion(), other.operatingSystemVersion())
                && Objects.equals(patchLevel(), other.patchLevel())
                && Objects.equals(firstAccessedTime(), other.firstAccessedTime())
                && Objects.equals(lastAccessedTime(), other.lastAccessedTime()) && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDeviceResponse").add("Status", statusAsString()).add("Model", model())
                .add("Manufacturer", manufacturer()).add("OperatingSystem", operatingSystem())
                .add("OperatingSystemVersion", operatingSystemVersion()).add("PatchLevel", patchLevel())
                .add("FirstAccessedTime", firstAccessedTime()).add("LastAccessedTime", lastAccessedTime())
                .add("Username", username()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Model":
            return Optional.ofNullable(clazz.cast(model()));
        case "Manufacturer":
            return Optional.ofNullable(clazz.cast(manufacturer()));
        case "OperatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystem()));
        case "OperatingSystemVersion":
            return Optional.ofNullable(clazz.cast(operatingSystemVersion()));
        case "PatchLevel":
            return Optional.ofNullable(clazz.cast(patchLevel()));
        case "FirstAccessedTime":
            return Optional.ofNullable(clazz.cast(firstAccessedTime()));
        case "LastAccessedTime":
            return Optional.ofNullable(clazz.cast(lastAccessedTime()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceResponse, T> g) {
        return obj -> g.apply((DescribeDeviceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkLinkResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDeviceResponse> {
        /**
         * <p>
         * The current state of the device.
         * </p>
         * 
         * @param status
         *        The current state of the device.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the device.
         * </p>
         * 
         * @param status
         *        The current state of the device.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder status(DeviceStatus status);

        /**
         * <p>
         * The model of the device.
         * </p>
         * 
         * @param model
         *        The model of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * The manufacturer of the device.
         * </p>
         * 
         * @param manufacturer
         *        The manufacturer of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manufacturer(String manufacturer);

        /**
         * <p>
         * The operating system of the device.
         * </p>
         * 
         * @param operatingSystem
         *        The operating system of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * The operating system version of the device.
         * </p>
         * 
         * @param operatingSystemVersion
         *        The operating system version of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystemVersion(String operatingSystemVersion);

        /**
         * <p>
         * The operating system patch level of the device.
         * </p>
         * 
         * @param patchLevel
         *        The operating system patch level of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchLevel(String patchLevel);

        /**
         * <p>
         * The date that the device first signed in to Amazon WorkLink.
         * </p>
         * 
         * @param firstAccessedTime
         *        The date that the device first signed in to Amazon WorkLink.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstAccessedTime(Instant firstAccessedTime);

        /**
         * <p>
         * The date that the device last accessed Amazon WorkLink.
         * </p>
         * 
         * @param lastAccessedTime
         *        The date that the device last accessed Amazon WorkLink.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccessedTime(Instant lastAccessedTime);

        /**
         * <p>
         * The user name associated with the device.
         * </p>
         * 
         * @param username
         *        The user name associated with the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);
    }

    static final class BuilderImpl extends WorkLinkResponse.BuilderImpl implements Builder {
        private String status;

        private String model;

        private String manufacturer;

        private String operatingSystem;

        private String operatingSystemVersion;

        private String patchLevel;

        private Instant firstAccessedTime;

        private Instant lastAccessedTime;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceResponse model) {
            super(model);
            status(model.status);
            model(model.model);
            manufacturer(model.manufacturer);
            operatingSystem(model.operatingSystem);
            operatingSystemVersion(model.operatingSystemVersion);
            patchLevel(model.patchLevel);
            firstAccessedTime(model.firstAccessedTime);
            lastAccessedTime(model.lastAccessedTime);
            username(model.username);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(DeviceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getModel() {
            return model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        @Transient
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getManufacturer() {
            return manufacturer;
        }

        public final void setManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
        }

        @Override
        @Transient
        public final Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        @Transient
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public final String getOperatingSystemVersion() {
            return operatingSystemVersion;
        }

        public final void setOperatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
        }

        @Override
        @Transient
        public final Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            return this;
        }

        public final String getPatchLevel() {
            return patchLevel;
        }

        public final void setPatchLevel(String patchLevel) {
            this.patchLevel = patchLevel;
        }

        @Override
        @Transient
        public final Builder patchLevel(String patchLevel) {
            this.patchLevel = patchLevel;
            return this;
        }

        public final Instant getFirstAccessedTime() {
            return firstAccessedTime;
        }

        public final void setFirstAccessedTime(Instant firstAccessedTime) {
            this.firstAccessedTime = firstAccessedTime;
        }

        @Override
        @Transient
        public final Builder firstAccessedTime(Instant firstAccessedTime) {
            this.firstAccessedTime = firstAccessedTime;
            return this;
        }

        public final Instant getLastAccessedTime() {
            return lastAccessedTime;
        }

        public final void setLastAccessedTime(Instant lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
        }

        @Override
        @Transient
        public final Builder lastAccessedTime(Instant lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        @Transient
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public DescribeDeviceResponse build() {
            return new DescribeDeviceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
