/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateWebsiteAuthorizationProviderRequest extends WorkLinkRequest implements
        ToCopyableBuilder<AssociateWebsiteAuthorizationProviderRequest.Builder, AssociateWebsiteAuthorizationProviderRequest> {
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetArn").getter(getter(AssociateWebsiteAuthorizationProviderRequest::fleetArn))
            .setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()).build();

    private static final SdkField<String> AUTHORIZATION_PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationProviderType")
            .getter(getter(AssociateWebsiteAuthorizationProviderRequest::authorizationProviderTypeAsString))
            .setter(setter(Builder::authorizationProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationProviderType").build())
            .build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(AssociateWebsiteAuthorizationProviderRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ARN_FIELD,
            AUTHORIZATION_PROVIDER_TYPE_FIELD, DOMAIN_NAME_FIELD));

    private final String fleetArn;

    private final String authorizationProviderType;

    private final String domainName;

    private AssociateWebsiteAuthorizationProviderRequest(BuilderImpl builder) {
        super(builder);
        this.fleetArn = builder.fleetArn;
        this.authorizationProviderType = builder.authorizationProviderType;
        this.domainName = builder.domainName;
    }

    /**
     * <p>
     * The ARN of the fleet.
     * </p>
     * 
     * @return The ARN of the fleet.
     */
    public final String fleetArn() {
        return fleetArn;
    }

    /**
     * <p>
     * The authorization provider type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authorizationProviderType} will return {@link AuthorizationProviderType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authorizationProviderTypeAsString}.
     * </p>
     * 
     * @return The authorization provider type.
     * @see AuthorizationProviderType
     */
    public final AuthorizationProviderType authorizationProviderType() {
        return AuthorizationProviderType.fromValue(authorizationProviderType);
    }

    /**
     * <p>
     * The authorization provider type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authorizationProviderType} will return {@link AuthorizationProviderType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authorizationProviderTypeAsString}.
     * </p>
     * 
     * @return The authorization provider type.
     * @see AuthorizationProviderType
     */
    public final String authorizationProviderTypeAsString() {
        return authorizationProviderType;
    }

    /**
     * <p>
     * The domain name of the authorization provider. This applies only to SAML-based authorization providers.
     * </p>
     * 
     * @return The domain name of the authorization provider. This applies only to SAML-based authorization providers.
     */
    public final String domainName() {
        return domainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateWebsiteAuthorizationProviderRequest)) {
            return false;
        }
        AssociateWebsiteAuthorizationProviderRequest other = (AssociateWebsiteAuthorizationProviderRequest) obj;
        return Objects.equals(fleetArn(), other.fleetArn())
                && Objects.equals(authorizationProviderTypeAsString(), other.authorizationProviderTypeAsString())
                && Objects.equals(domainName(), other.domainName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateWebsiteAuthorizationProviderRequest").add("FleetArn", fleetArn())
                .add("AuthorizationProviderType", authorizationProviderTypeAsString()).add("DomainName", domainName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "AuthorizationProviderType":
            return Optional.ofNullable(clazz.cast(authorizationProviderTypeAsString()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateWebsiteAuthorizationProviderRequest, T> g) {
        return obj -> g.apply((AssociateWebsiteAuthorizationProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkLinkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateWebsiteAuthorizationProviderRequest> {
        /**
         * <p>
         * The ARN of the fleet.
         * </p>
         * 
         * @param fleetArn
         *        The ARN of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * The authorization provider type.
         * </p>
         * 
         * @param authorizationProviderType
         *        The authorization provider type.
         * @see AuthorizationProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationProviderType
         */
        Builder authorizationProviderType(String authorizationProviderType);

        /**
         * <p>
         * The authorization provider type.
         * </p>
         * 
         * @param authorizationProviderType
         *        The authorization provider type.
         * @see AuthorizationProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationProviderType
         */
        Builder authorizationProviderType(AuthorizationProviderType authorizationProviderType);

        /**
         * <p>
         * The domain name of the authorization provider. This applies only to SAML-based authorization providers.
         * </p>
         * 
         * @param domainName
         *        The domain name of the authorization provider. This applies only to SAML-based authorization
         *        providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkLinkRequest.BuilderImpl implements Builder {
        private String fleetArn;

        private String authorizationProviderType;

        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateWebsiteAuthorizationProviderRequest model) {
            super(model);
            fleetArn(model.fleetArn);
            authorizationProviderType(model.authorizationProviderType);
            domainName(model.domainName);
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        @Transient
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getAuthorizationProviderType() {
            return authorizationProviderType;
        }

        public final void setAuthorizationProviderType(String authorizationProviderType) {
            this.authorizationProviderType = authorizationProviderType;
        }

        @Override
        @Transient
        public final Builder authorizationProviderType(String authorizationProviderType) {
            this.authorizationProviderType = authorizationProviderType;
            return this;
        }

        @Override
        @Transient
        public final Builder authorizationProviderType(AuthorizationProviderType authorizationProviderType) {
            this.authorizationProviderType(authorizationProviderType == null ? null : authorizationProviderType.toString());
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateWebsiteAuthorizationProviderRequest build() {
            return new AssociateWebsiteAuthorizationProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
