/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workdocs.model.SignedHeaderMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UploadMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UploadMetadata> {
    private static final SdkField<String> UPLOAD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UploadUrl").getter(UploadMetadata.getter(UploadMetadata::uploadUrl)).setter(UploadMetadata.setter(Builder::uploadUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadUrl").build()}).build();
    private static final SdkField<Map<String, String>> SIGNED_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SignedHeaders").getter(UploadMetadata.getter(UploadMetadata::signedHeaders)).setter(UploadMetadata.setter(Builder::signedHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignedHeaders").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOAD_URL_FIELD, SIGNED_HEADERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UploadMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String uploadUrl;
    private final Map<String, String> signedHeaders;

    private UploadMetadata(BuilderImpl builder) {
        this.uploadUrl = builder.uploadUrl;
        this.signedHeaders = builder.signedHeaders;
    }

    public final String uploadUrl() {
        return this.uploadUrl;
    }

    public final boolean hasSignedHeaders() {
        return this.signedHeaders != null && !(this.signedHeaders instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> signedHeaders() {
        return this.signedHeaders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSignedHeaders() ? this.signedHeaders() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadMetadata)) {
            return false;
        }
        UploadMetadata other = (UploadMetadata)obj;
        return Objects.equals(this.uploadUrl(), other.uploadUrl()) && this.hasSignedHeaders() == other.hasSignedHeaders() && Objects.equals(this.signedHeaders(), other.signedHeaders());
    }

    public final String toString() {
        return ToString.builder((String)"UploadMetadata").add("UploadUrl", (Object)(this.uploadUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("SignedHeaders", this.hasSignedHeaders() ? this.signedHeaders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UploadUrl": {
                return Optional.ofNullable(clazz.cast(this.uploadUrl()));
            }
            case "SignedHeaders": {
                return Optional.ofNullable(clazz.cast(this.signedHeaders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UploadUrl", UPLOAD_URL_FIELD);
        map.put("SignedHeaders", SIGNED_HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UploadMetadata, T> g) {
        return obj -> g.apply((UploadMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String uploadUrl;
        private Map<String, String> signedHeaders = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UploadMetadata model) {
            this.uploadUrl(model.uploadUrl);
            this.signedHeaders(model.signedHeaders);
        }

        public final String getUploadUrl() {
            return this.uploadUrl;
        }

        public final void setUploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
        }

        @Override
        public final Builder uploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
            return this;
        }

        public final Map<String, String> getSignedHeaders() {
            if (this.signedHeaders instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.signedHeaders;
        }

        public final void setSignedHeaders(Map<String, String> signedHeaders) {
            this.signedHeaders = SignedHeaderMapCopier.copy(signedHeaders);
        }

        @Override
        public final Builder signedHeaders(Map<String, String> signedHeaders) {
            this.signedHeaders = SignedHeaderMapCopier.copy(signedHeaders);
            return this;
        }

        public UploadMetadata build() {
            return new UploadMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UploadMetadata> {
        public Builder uploadUrl(String var1);

        public Builder signedHeaders(Map<String, String> var1);
    }
}

