/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SearchCollectionType {
    OWNED("OWNED"),
    SHARED_WITH_ME("SHARED_WITH_ME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SearchCollectionType> VALUE_MAP;
    private final String value;

    private SearchCollectionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SearchCollectionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SearchCollectionType> knownValues() {
        EnumSet<SearchCollectionType> knownValues = EnumSet.allOf(SearchCollectionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SearchCollectionType.class, SearchCollectionType::toString);
    }
}

