/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LocaleType {
    EN("en"),
    FR("fr"),
    KO("ko"),
    DE("de"),
    ES("es"),
    JA("ja"),
    RU("ru"),
    ZH_CN("zh_CN"),
    ZH_TW("zh_TW"),
    PT_BR("pt_BR"),
    DEFAULT("default"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LocaleType> VALUE_MAP;
    private final String value;

    private LocaleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LocaleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LocaleType> knownValues() {
        EnumSet<LocaleType> knownValues = EnumSet.allOf(LocaleType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LocaleType.class, LocaleType::toString);
    }
}

