/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.WorkDocsServiceClientConfiguration;
import software.amazon.awssdk.services.workdocs.internal.WorkDocsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadRequest;
import software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadResponse;
import software.amazon.awssdk.services.workdocs.model.ActivateUserRequest;
import software.amazon.awssdk.services.workdocs.model.ActivateUserResponse;
import software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.ConcurrentModificationException;
import software.amazon.awssdk.services.workdocs.model.ConflictingOperationException;
import software.amazon.awssdk.services.workdocs.model.CreateCommentRequest;
import software.amazon.awssdk.services.workdocs.model.CreateCommentResponse;
import software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataRequest;
import software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataResponse;
import software.amazon.awssdk.services.workdocs.model.CreateFolderRequest;
import software.amazon.awssdk.services.workdocs.model.CreateFolderResponse;
import software.amazon.awssdk.services.workdocs.model.CreateLabelsRequest;
import software.amazon.awssdk.services.workdocs.model.CreateLabelsResponse;
import software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionRequest;
import software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionResponse;
import software.amazon.awssdk.services.workdocs.model.CreateUserRequest;
import software.amazon.awssdk.services.workdocs.model.CreateUserResponse;
import software.amazon.awssdk.services.workdocs.model.CustomMetadataLimitExceededException;
import software.amazon.awssdk.services.workdocs.model.DeactivateUserRequest;
import software.amazon.awssdk.services.workdocs.model.DeactivateUserResponse;
import software.amazon.awssdk.services.workdocs.model.DeactivatingLastSystemUserException;
import software.amazon.awssdk.services.workdocs.model.DeleteCommentRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteCommentResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteLabelsRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteLabelsResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteUserRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteUserResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse;
import software.amazon.awssdk.services.workdocs.model.DocumentLockedForCommentsException;
import software.amazon.awssdk.services.workdocs.model.DraftUploadOutOfSyncException;
import software.amazon.awssdk.services.workdocs.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.workdocs.model.EntityNotExistsException;
import software.amazon.awssdk.services.workdocs.model.FailedDependencyException;
import software.amazon.awssdk.services.workdocs.model.GetCurrentUserRequest;
import software.amazon.awssdk.services.workdocs.model.GetCurrentUserResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentPathResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.GetFolderPathRequest;
import software.amazon.awssdk.services.workdocs.model.GetFolderPathResponse;
import software.amazon.awssdk.services.workdocs.model.GetFolderRequest;
import software.amazon.awssdk.services.workdocs.model.GetFolderResponse;
import software.amazon.awssdk.services.workdocs.model.GetResourcesRequest;
import software.amazon.awssdk.services.workdocs.model.GetResourcesResponse;
import software.amazon.awssdk.services.workdocs.model.IllegalUserStateException;
import software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest;
import software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse;
import software.amazon.awssdk.services.workdocs.model.InvalidArgumentException;
import software.amazon.awssdk.services.workdocs.model.InvalidCommentOperationException;
import software.amazon.awssdk.services.workdocs.model.InvalidOperationException;
import software.amazon.awssdk.services.workdocs.model.InvalidPasswordException;
import software.amazon.awssdk.services.workdocs.model.LimitExceededException;
import software.amazon.awssdk.services.workdocs.model.ProhibitedStateException;
import software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionRequest;
import software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionResponse;
import software.amazon.awssdk.services.workdocs.model.RequestedEntityTooLargeException;
import software.amazon.awssdk.services.workdocs.model.ResourceAlreadyCheckedOutException;
import software.amazon.awssdk.services.workdocs.model.RestoreDocumentVersionsRequest;
import software.amazon.awssdk.services.workdocs.model.RestoreDocumentVersionsResponse;
import software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest;
import software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse;
import software.amazon.awssdk.services.workdocs.model.ServiceUnavailableException;
import software.amazon.awssdk.services.workdocs.model.StorageLimitExceededException;
import software.amazon.awssdk.services.workdocs.model.StorageLimitWillExceedException;
import software.amazon.awssdk.services.workdocs.model.TooManyLabelsException;
import software.amazon.awssdk.services.workdocs.model.TooManySubscriptionsException;
import software.amazon.awssdk.services.workdocs.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.workdocs.model.UnauthorizedResourceAccessException;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateFolderResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateUserRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateUserResponse;
import software.amazon.awssdk.services.workdocs.model.WorkDocsException;
import software.amazon.awssdk.services.workdocs.transform.AbortDocumentVersionUploadRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.ActivateUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.AddResourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateCommentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateCustomMetadataRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateLabelsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateNotificationSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeactivateUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteCommentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteCustomMetadataRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteDocumentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteDocumentVersionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteFolderContentsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteLabelsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteNotificationSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeActivitiesRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeCommentsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeDocumentVersionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeFolderContentsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeGroupsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeNotificationSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeResourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeRootFoldersRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeUsersRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetCurrentUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentPathRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentVersionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetFolderPathRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetResourcesRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.InitiateDocumentVersionUploadRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.RemoveAllResourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.RemoveResourcePermissionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.RestoreDocumentVersionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.SearchResourcesRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateDocumentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateDocumentVersionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultWorkDocsClient
implements WorkDocsClient {
    private static final Logger log = Logger.loggerFor(DefaultWorkDocsClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWorkDocsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"WorkDocs#2.40.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbortDocumentVersionUploadResponse abortDocumentVersionUpload(AbortDocumentVersionUploadRequest abortDocumentVersionUploadRequest) throws EntityNotExistsException, ProhibitedStateException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, ConcurrentModificationException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AbortDocumentVersionUploadResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)abortDocumentVersionUploadRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, abortDocumentVersionUploadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AbortDocumentVersionUpload");
            AbortDocumentVersionUploadResponse abortDocumentVersionUploadResponse = (AbortDocumentVersionUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AbortDocumentVersionUpload").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)abortDocumentVersionUploadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AbortDocumentVersionUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return abortDocumentVersionUploadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$abortDocumentVersionUpload$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivateUserResponse activateUser(ActivateUserRequest activateUserRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ActivateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)activateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, activateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ActivateUser");
            ActivateUserResponse activateUserResponse = (ActivateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ActivateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)activateUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ActivateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return activateUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$activateUser$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddResourcePermissionsResponse addResourcePermissions(AddResourcePermissionsRequest addResourcePermissionsRequest) throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddResourcePermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addResourcePermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, addResourcePermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddResourcePermissions");
            AddResourcePermissionsResponse addResourcePermissionsResponse = (AddResourcePermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddResourcePermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addResourcePermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddResourcePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addResourcePermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$addResourcePermissions$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCommentResponse createComment(CreateCommentRequest createCommentRequest) throws EntityNotExistsException, ProhibitedStateException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, DocumentLockedForCommentsException, InvalidCommentOperationException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCommentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCommentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, createCommentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateComment");
            CreateCommentResponse createCommentResponse = (CreateCommentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateComment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCommentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCommentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCommentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$createComment$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCustomMetadataResponse createCustomMetadata(CreateCustomMetadataRequest createCustomMetadataRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, ProhibitedStateException, CustomMetadataLimitExceededException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCustomMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, createCustomMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomMetadata");
            CreateCustomMetadataResponse createCustomMetadataResponse = (CreateCustomMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomMetadata").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCustomMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCustomMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCustomMetadataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$createCustomMetadata$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFolderResponse createFolder(CreateFolderRequest createFolderRequest) throws EntityNotExistsException, EntityAlreadyExistsException, ProhibitedStateException, ConflictingOperationException, ConcurrentModificationException, LimitExceededException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFolderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFolderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, createFolderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFolder");
            CreateFolderResponse createFolderResponse = (CreateFolderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFolder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createFolderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFolderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFolderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$createFolder$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLabelsResponse createLabels(CreateLabelsRequest createLabelsRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, TooManyLabelsException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLabelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLabelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, createLabelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLabels");
            CreateLabelsResponse createLabelsResponse = (CreateLabelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLabels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createLabelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLabelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLabelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$createLabels$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateNotificationSubscriptionResponse createNotificationSubscription(CreateNotificationSubscriptionRequest createNotificationSubscriptionRequest) throws UnauthorizedResourceAccessException, TooManySubscriptionsException, ServiceUnavailableException, InvalidArgumentException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNotificationSubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createNotificationSubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, createNotificationSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateNotificationSubscription");
            CreateNotificationSubscriptionResponse createNotificationSubscriptionResponse = (CreateNotificationSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNotificationSubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createNotificationSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateNotificationSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createNotificationSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$createNotificationSubscription$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws EntityAlreadyExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, createUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUser");
            CreateUserResponse createUserResponse = (CreateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$createUser$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeactivateUserResponse deactivateUser(DeactivateUserRequest deactivateUserRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeactivateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deactivateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, deactivateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeactivateUser");
            DeactivateUserResponse deactivateUserResponse = (DeactivateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeactivateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deactivateUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeactivateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deactivateUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$deactivateUser$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCommentResponse deleteComment(DeleteCommentRequest deleteCommentRequest) throws EntityNotExistsException, ProhibitedStateException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, DocumentLockedForCommentsException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCommentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCommentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, deleteCommentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteComment");
            DeleteCommentResponse deleteCommentResponse = (DeleteCommentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteComment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteCommentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCommentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCommentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$deleteComment$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCustomMetadataResponse deleteCustomMetadata(DeleteCustomMetadataRequest deleteCustomMetadataRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, ProhibitedStateException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCustomMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, deleteCustomMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomMetadata");
            DeleteCustomMetadataResponse deleteCustomMetadataResponse = (DeleteCustomMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomMetadata").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteCustomMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCustomMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCustomMetadataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$deleteCustomMetadata$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDocumentResponse deleteDocument(DeleteDocumentRequest deleteDocumentRequest) throws EntityNotExistsException, LimitExceededException, ProhibitedStateException, ConflictingOperationException, ConcurrentModificationException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDocumentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, deleteDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDocument");
            DeleteDocumentResponse deleteDocumentResponse = (DeleteDocumentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDocument").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDocumentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDocumentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$deleteDocument$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDocumentVersionResponse deleteDocumentVersion(DeleteDocumentVersionRequest deleteDocumentVersionRequest) throws EntityNotExistsException, ProhibitedStateException, ConflictingOperationException, ConcurrentModificationException, UnauthorizedResourceAccessException, FailedDependencyException, InvalidOperationException, UnauthorizedOperationException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDocumentVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDocumentVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, deleteDocumentVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDocumentVersion");
            DeleteDocumentVersionResponse deleteDocumentVersionResponse = (DeleteDocumentVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDocumentVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDocumentVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDocumentVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDocumentVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$deleteDocumentVersion$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFolderResponse deleteFolder(DeleteFolderRequest deleteFolderRequest) throws EntityNotExistsException, LimitExceededException, ProhibitedStateException, ConflictingOperationException, ConcurrentModificationException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFolderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFolderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, deleteFolderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFolder");
            DeleteFolderResponse deleteFolderResponse = (DeleteFolderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFolder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFolderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFolderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFolderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$deleteFolder$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFolderContentsResponse deleteFolderContents(DeleteFolderContentsRequest deleteFolderContentsRequest) throws EntityNotExistsException, ProhibitedStateException, ConflictingOperationException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFolderContentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFolderContentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, deleteFolderContentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFolderContents");
            DeleteFolderContentsResponse deleteFolderContentsResponse = (DeleteFolderContentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFolderContents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFolderContentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFolderContentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFolderContentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$deleteFolderContents$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLabelsResponse deleteLabels(DeleteLabelsRequest deleteLabelsRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLabelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLabelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, deleteLabelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLabels");
            DeleteLabelsResponse deleteLabelsResponse = (DeleteLabelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLabels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteLabelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLabelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLabelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$deleteLabels$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNotificationSubscriptionResponse deleteNotificationSubscription(DeleteNotificationSubscriptionRequest deleteNotificationSubscriptionRequest) throws UnauthorizedResourceAccessException, EntityNotExistsException, ServiceUnavailableException, ProhibitedStateException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNotificationSubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteNotificationSubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, deleteNotificationSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNotificationSubscription");
            DeleteNotificationSubscriptionResponse deleteNotificationSubscriptionResponse = (DeleteNotificationSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNotificationSubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteNotificationSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteNotificationSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteNotificationSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$deleteNotificationSubscription$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, deleteUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUser");
            DeleteUserResponse deleteUserResponse = (DeleteUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$deleteUser$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeActivitiesResponse describeActivities(DescribeActivitiesRequest describeActivitiesRequest) throws UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeActivitiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeActivitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, describeActivitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeActivities");
            DescribeActivitiesResponse describeActivitiesResponse = (DescribeActivitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeActivities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeActivitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeActivitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeActivitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$describeActivities$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCommentsResponse describeComments(DescribeCommentsRequest describeCommentsRequest) throws EntityNotExistsException, ProhibitedStateException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCommentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCommentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, describeCommentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeComments");
            DescribeCommentsResponse describeCommentsResponse = (DescribeCommentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeComments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCommentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCommentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCommentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$describeComments$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDocumentVersionsResponse describeDocumentVersions(DescribeDocumentVersionsRequest describeDocumentVersionsRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, InvalidPasswordException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDocumentVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDocumentVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, describeDocumentVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDocumentVersions");
            DescribeDocumentVersionsResponse describeDocumentVersionsResponse = (DescribeDocumentVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDocumentVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDocumentVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDocumentVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDocumentVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$describeDocumentVersions$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFolderContentsResponse describeFolderContents(DescribeFolderContentsRequest describeFolderContentsRequest) throws EntityNotExistsException, UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFolderContentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFolderContentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, describeFolderContentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFolderContents");
            DescribeFolderContentsResponse describeFolderContentsResponse = (DescribeFolderContentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFolderContents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFolderContentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFolderContentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFolderContentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$describeFolderContents$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGroupsResponse describeGroups(DescribeGroupsRequest describeGroupsRequest) throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, describeGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGroups");
            DescribeGroupsResponse describeGroupsResponse = (DescribeGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$describeGroups$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeNotificationSubscriptionsResponse describeNotificationSubscriptions(DescribeNotificationSubscriptionsRequest describeNotificationSubscriptionsRequest) throws UnauthorizedResourceAccessException, EntityNotExistsException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeNotificationSubscriptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeNotificationSubscriptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, describeNotificationSubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNotificationSubscriptions");
            DescribeNotificationSubscriptionsResponse describeNotificationSubscriptionsResponse = (DescribeNotificationSubscriptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNotificationSubscriptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeNotificationSubscriptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeNotificationSubscriptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeNotificationSubscriptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$describeNotificationSubscriptions$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeResourcePermissionsResponse describeResourcePermissions(DescribeResourcePermissionsRequest describeResourcePermissionsRequest) throws InvalidArgumentException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourcePermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeResourcePermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, describeResourcePermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResourcePermissions");
            DescribeResourcePermissionsResponse describeResourcePermissionsResponse = (DescribeResourcePermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResourcePermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeResourcePermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeResourcePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeResourcePermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$describeResourcePermissions$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRootFoldersResponse describeRootFolders(DescribeRootFoldersRequest describeRootFoldersRequest) throws UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRootFoldersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRootFoldersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, describeRootFoldersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRootFolders");
            DescribeRootFoldersResponse describeRootFoldersResponse = (DescribeRootFoldersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRootFolders").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRootFoldersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRootFoldersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRootFoldersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$describeRootFolders$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeUsersResponse describeUsers(DescribeUsersRequest describeUsersRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, InvalidArgumentException, RequestedEntityTooLargeException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUsersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, describeUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUsers");
            DescribeUsersResponse describeUsersResponse = (DescribeUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeUsersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeUsersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$describeUsers$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCurrentUserResponse getCurrentUser(GetCurrentUserRequest getCurrentUserRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCurrentUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCurrentUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, getCurrentUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCurrentUser");
            GetCurrentUserResponse getCurrentUserResponse = (GetCurrentUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCurrentUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCurrentUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCurrentUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCurrentUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$getCurrentUser$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDocumentResponse getDocument(GetDocumentRequest getDocumentRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException, ServiceUnavailableException, InvalidPasswordException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDocumentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, getDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDocument");
            GetDocumentResponse getDocumentResponse = (GetDocumentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDocument").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDocumentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDocumentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$getDocument$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDocumentPathResponse getDocumentPath(GetDocumentPathRequest getDocumentPathRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDocumentPathResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDocumentPathRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, getDocumentPathRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDocumentPath");
            GetDocumentPathResponse getDocumentPathResponse = (GetDocumentPathResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDocumentPath").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDocumentPathRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDocumentPathRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDocumentPathResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$getDocumentPath$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDocumentVersionResponse getDocumentVersion(GetDocumentVersionRequest getDocumentVersionRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, InvalidPasswordException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDocumentVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDocumentVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, getDocumentVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDocumentVersion");
            GetDocumentVersionResponse getDocumentVersionResponse = (GetDocumentVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDocumentVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDocumentVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDocumentVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDocumentVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$getDocumentVersion$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFolderResponse getFolder(GetFolderRequest getFolderRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, InvalidArgumentException, FailedDependencyException, ServiceUnavailableException, ProhibitedStateException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFolderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getFolderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, getFolderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFolder");
            GetFolderResponse getFolderResponse = (GetFolderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFolder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getFolderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetFolderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFolderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$getFolder$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFolderPathResponse getFolderPath(GetFolderPathRequest getFolderPathRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFolderPathResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getFolderPathRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, getFolderPathRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFolderPath");
            GetFolderPathResponse getFolderPathResponse = (GetFolderPathResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFolderPath").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getFolderPathRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetFolderPathRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFolderPathResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$getFolderPath$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourcesResponse getResources(GetResourcesRequest getResourcesRequest) throws UnauthorizedResourceAccessException, UnauthorizedOperationException, InvalidArgumentException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, getResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResources");
            GetResourcesResponse getResourcesResponse = (GetResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$getResources$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitiateDocumentVersionUploadResponse initiateDocumentVersionUpload(InitiateDocumentVersionUploadRequest initiateDocumentVersionUploadRequest) throws EntityNotExistsException, EntityAlreadyExistsException, StorageLimitExceededException, StorageLimitWillExceedException, LimitExceededException, ProhibitedStateException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, DraftUploadOutOfSyncException, ResourceAlreadyCheckedOutException, InvalidPasswordException, InvalidArgumentException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InitiateDocumentVersionUploadResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)initiateDocumentVersionUploadRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, initiateDocumentVersionUploadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InitiateDocumentVersionUpload");
            InitiateDocumentVersionUploadResponse initiateDocumentVersionUploadResponse = (InitiateDocumentVersionUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InitiateDocumentVersionUpload").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)initiateDocumentVersionUploadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new InitiateDocumentVersionUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return initiateDocumentVersionUploadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$initiateDocumentVersionUpload$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveAllResourcePermissionsResponse removeAllResourcePermissions(RemoveAllResourcePermissionsRequest removeAllResourcePermissionsRequest) throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveAllResourcePermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeAllResourcePermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, removeAllResourcePermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveAllResourcePermissions");
            RemoveAllResourcePermissionsResponse removeAllResourcePermissionsResponse = (RemoveAllResourcePermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveAllResourcePermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeAllResourcePermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveAllResourcePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeAllResourcePermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$removeAllResourcePermissions$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveResourcePermissionResponse removeResourcePermission(RemoveResourcePermissionRequest removeResourcePermissionRequest) throws UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveResourcePermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeResourcePermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, removeResourcePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveResourcePermission");
            RemoveResourcePermissionResponse removeResourcePermissionResponse = (RemoveResourcePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveResourcePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeResourcePermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveResourcePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeResourcePermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$removeResourcePermission$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreDocumentVersionsResponse restoreDocumentVersions(RestoreDocumentVersionsRequest restoreDocumentVersionsRequest) throws EntityNotExistsException, ProhibitedStateException, ConflictingOperationException, ConcurrentModificationException, UnauthorizedResourceAccessException, FailedDependencyException, InvalidOperationException, UnauthorizedOperationException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreDocumentVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreDocumentVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, restoreDocumentVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreDocumentVersions");
            RestoreDocumentVersionsResponse restoreDocumentVersionsResponse = (RestoreDocumentVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreDocumentVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)restoreDocumentVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreDocumentVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreDocumentVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$restoreDocumentVersions$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchResourcesResponse searchResources(SearchResourcesRequest searchResourcesRequest) throws InvalidArgumentException, UnauthorizedResourceAccessException, UnauthorizedOperationException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchResourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, searchResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchResources");
            SearchResourcesResponse searchResourcesResponse = (SearchResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)searchResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$searchResources$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDocumentResponse updateDocument(UpdateDocumentRequest updateDocumentRequest) throws EntityNotExistsException, EntityAlreadyExistsException, LimitExceededException, ProhibitedStateException, ConflictingOperationException, ConcurrentModificationException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDocumentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, updateDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDocument");
            UpdateDocumentResponse updateDocumentResponse = (UpdateDocumentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDocument").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDocumentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDocumentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$updateDocument$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDocumentVersionResponse updateDocumentVersion(UpdateDocumentVersionRequest updateDocumentVersionRequest) throws EntityNotExistsException, ProhibitedStateException, ConcurrentModificationException, InvalidOperationException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDocumentVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDocumentVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, updateDocumentVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDocumentVersion");
            UpdateDocumentVersionResponse updateDocumentVersionResponse = (UpdateDocumentVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDocumentVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDocumentVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDocumentVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDocumentVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$updateDocumentVersion$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFolderResponse updateFolder(UpdateFolderRequest updateFolderRequest) throws EntityNotExistsException, EntityAlreadyExistsException, ProhibitedStateException, ConflictingOperationException, ConcurrentModificationException, LimitExceededException, UnauthorizedOperationException, UnauthorizedResourceAccessException, FailedDependencyException, ServiceUnavailableException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFolderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFolderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, updateFolderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFolder");
            UpdateFolderResponse updateFolderResponse = (UpdateFolderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFolder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateFolderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFolderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFolderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$updateFolder$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws EntityNotExistsException, UnauthorizedOperationException, UnauthorizedResourceAccessException, IllegalUserStateException, ProhibitedStateException, FailedDependencyException, ServiceUnavailableException, DeactivatingLastSystemUserException, InvalidArgumentException, AwsServiceException, SdkClientException, WorkDocsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "CustomMetadataLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                }
                case "UnauthorizedResourceAccessException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                }
                case "TooManySubscriptionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                }
                case "EntityAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                }
                case "EntityNotExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                }
                case "DocumentLockedForCommentsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                }
                case "StorageLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                }
                case "StorageLimitWillExceedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                }
                case "ProhibitedStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "IllegalUserStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ConflictingOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                }
                case "InvalidCommentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                }
                case "InvalidPasswordException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                }
                case "UnauthorizedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                }
                case "TooManyLabelsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                }
                case "DraftUploadOutOfSyncException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                }
                case "ResourceAlreadyCheckedOutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                }
                case "RequestedEntityTooLargeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "DeactivatingLastSystemUserException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsClient.resolveMetricPublishers(clientConfiguration, updateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUser");
            UpdateUserResponse updateUserResponse = (UpdateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsClient.lambda$updateUser$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "workdocs";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        WorkDocsServiceClientConfigurationBuilder serviceConfigBuilder = new WorkDocsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(WorkDocsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final WorkDocsServiceClientConfiguration serviceClientConfiguration() {
        return new WorkDocsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateUser$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFolder$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDocumentVersion$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDocument$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchResources$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreDocumentVersions$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeResourcePermission$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeAllResourcePermissions$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$initiateDocumentVersionUpload$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResources$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFolderPath$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFolder$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDocumentVersion$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDocumentPath$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDocument$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCurrentUser$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeUsers$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRootFolders$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeResourcePermissions$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeNotificationSubscriptions$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGroups$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFolderContents$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDocumentVersions$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeComments$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeActivities$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUser$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteNotificationSubscription$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLabels$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFolderContents$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFolder$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDocumentVersion$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDocument$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomMetadata$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteComment$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deactivateUser$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUser$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createNotificationSubscription$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLabels$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFolder$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomMetadata$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createComment$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addResourcePermissions$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$activateUser$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$abortDocumentVersionUpload$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

